/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_player_program_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_player_programlist_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.types.size_t;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.Program;

public final class ProgramApi
extends BaseApi {
    ProgramApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public List<Program> list() {
        libvlc_player_programlist_t programList = LibVlc.libvlc_media_player_get_programlist((libvlc_media_player_t)this.mediaPlayerInstance);
        if (programList != null) {
            int count = LibVlc.libvlc_player_programlist_count((libvlc_player_programlist_t)programList).intValue();
            ArrayList<Program> result = new ArrayList<Program>(count);
            for (int i = 0; i < count; ++i) {
                libvlc_player_program_t programInstance = LibVlc.libvlc_player_programlist_at((libvlc_player_programlist_t)programList, (size_t)new size_t((long)i));
                result.add(new Program(programInstance));
            }
            LibVlc.libvlc_player_programlist_delete((libvlc_player_programlist_t)programList);
            return result;
        }
        return Collections.emptyList();
    }

    public void select(int programId) {
        LibVlc.libvlc_media_player_select_program_id((libvlc_media_player_t)this.mediaPlayerInstance, (int)programId);
    }

    public Program selected() {
        libvlc_player_program_t programInstance = LibVlc.libvlc_media_player_get_selected_program((libvlc_media_player_t)this.mediaPlayerInstance);
        return ProgramApi.convertAndFree(programInstance);
    }

    public Program get(int programId) {
        libvlc_player_program_t programInstance = LibVlc.libvlc_media_player_get_program_from_id((libvlc_media_player_t)this.mediaPlayerInstance, (int)programId);
        return ProgramApi.convertAndFree(programInstance);
    }

    private static Program convertAndFree(libvlc_player_program_t programInstance) {
        if (programInstance != null) {
            Program program = new Program(programInstance);
            LibVlc.libvlc_player_program_delete((libvlc_player_program_t)programInstance);
            return program;
        }
        return null;
    }
}

