/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.WaitForSnapshot;

public final class SnapshotApi
extends BaseApi {
    private String snapshotDirectoryName;

    SnapshotApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void setSnapshotDirectory(String snapshotDirectoryName) {
        this.snapshotDirectoryName = snapshotDirectoryName;
    }

    public boolean save() {
        return this.save(0, 0);
    }

    public boolean save(int width, int height) {
        File snapshotDirectory = new File(this.snapshotDirectoryName == null ? System.getProperty("user.home") : this.snapshotDirectoryName);
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        return this.save(snapshotFile, width, height);
    }

    public boolean save(File file) {
        return this.save(file, 0, 0);
    }

    public boolean save(File file, int width, int height) {
        File snapshotDirectory = file.getParentFile();
        if (snapshotDirectory == null) {
            snapshotDirectory = new File(".");
        }
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        if (snapshotDirectory.exists()) {
            return LibVlc.libvlc_video_take_snapshot((libvlc_media_player_t)this.mediaPlayerInstance, (int)0, (String)file.getAbsolutePath(), (int)width, (int)height) == 0;
        }
        throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
    }

    public BufferedImage get() {
        return this.get(0, 0, 0L);
    }

    public BufferedImage get(int width, int height) {
        return this.get(width, height, 0L);
    }

    public BufferedImage get(long timeout) {
        return this.get(0, 0, timeout);
    }

    public BufferedImage get(int width, int height, long timeout) {
        File file = null;
        try {
            file = File.createTempFile("vlcj-snapshot-", ".png");
            WaitForSnapshot waiter = new WaitForSnapshot(this.mediaPlayer, file, width, height);
            String snapshot = timeout == 0L ? waiter.getSnapshot() : waiter.getSnapshot(timeout);
            BufferedImage bufferedImage = ImageIO.read(new File(snapshot));
            return bufferedImage;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

