/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.awt.Dimension;
import java.awt.Point;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_viewpoint_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.media.VideoProjection;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.DeinterlaceMode;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.Position;
import uk.co.caprica.vlcj.player.base.VideoFitMode;
import uk.co.caprica.vlcj.player.base.VideoStereoMode;
import uk.co.caprica.vlcj.player.base.Viewpoint;

public final class VideoApi
extends BaseApi {
    VideoApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void setDeinterlace(int deinterlace, DeinterlaceMode deinterlaceMode) {
        LibVlc.libvlc_video_set_deinterlace((libvlc_media_player_t)this.mediaPlayerInstance, (int)deinterlace, (String)(deinterlaceMode != null ? deinterlaceMode.stringValue() : null));
    }

    public void setAdjustVideo(boolean adjustVideo) {
        LibVlc.libvlc_video_set_adjust_int((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), (int)(adjustVideo ? 1 : 0));
    }

    public boolean isAdjustVideo() {
        return LibVlc.libvlc_video_get_adjust_int((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    public float contrast() {
        return LibVlc.libvlc_video_get_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    public void setContrast(float contrast) {
        LibVlc.libvlc_video_set_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), (float)contrast);
    }

    public float brightness() {
        return LibVlc.libvlc_video_get_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    public void setBrightness(float brightness) {
        LibVlc.libvlc_video_set_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), (float)brightness);
    }

    public float hue() {
        return LibVlc.libvlc_video_get_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    public void setHue(float hue) {
        LibVlc.libvlc_video_set_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), (float)hue);
    }

    public float saturation() {
        return LibVlc.libvlc_video_get_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    public void setSaturation(float saturation) {
        LibVlc.libvlc_video_set_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), (float)saturation);
    }

    public float gamma() {
        return LibVlc.libvlc_video_get_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    public void setGamma(float gamma) {
        LibVlc.libvlc_video_set_adjust_float((libvlc_media_player_t)this.mediaPlayerInstance, (int)libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), (float)gamma);
    }

    public void setProjectionMode(VideoProjection projectionMode) {
        LibVlc.libvlc_video_set_projection_mode((libvlc_media_player_t)this.mediaPlayerInstance, (int)projectionMode.intValue());
    }

    public void unsetProjectionMode() {
        LibVlc.libvlc_video_unset_projection_mode((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void setVideoTitleDisplay(Position position, int timeout) {
        LibVlc.libvlc_media_player_set_video_title_display((libvlc_media_player_t)this.mediaPlayerInstance, (int)position.intValue(), (int)timeout);
    }

    public String aspectRatio() {
        return NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_video_get_aspect_ratio((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    public void setAspectRatio(String aspectRatio) {
        LibVlc.libvlc_video_set_aspect_ratio((libvlc_media_player_t)this.mediaPlayerInstance, (String)aspectRatio);
    }

    public VideoFitMode displayFit() {
        return VideoFitMode.videoFitMode(LibVlc.libvlc_video_get_display_fit((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    public void setDisplayFit(VideoFitMode fitMode) {
        LibVlc.libvlc_video_set_display_fit((libvlc_media_player_t)this.mediaPlayerInstance, (int)fitMode.intValue());
    }

    public float scale() {
        return LibVlc.libvlc_video_get_scale((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void setScale(float factor) {
        LibVlc.libvlc_video_set_scale((libvlc_media_player_t)this.mediaPlayerInstance, (float)factor);
    }

    public void setCropRatio(int num, int den) {
        LibVlc.libvlc_video_set_crop_ratio((libvlc_media_player_t)this.mediaPlayerInstance, (int)num, (int)den);
    }

    public void setCropWindow(int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("Width and height must be non-zero");
        }
        LibVlc.libvlc_video_set_crop_window((libvlc_media_player_t)this.mediaPlayerInstance, (int)x, (int)y, (int)width, (int)height);
    }

    public void setCropBorder(int left, int top, int right, int bottom) {
        LibVlc.libvlc_video_set_crop_border((libvlc_media_player_t)this.mediaPlayerInstance, (int)left, (int)right, (int)top, (int)bottom);
    }

    public Dimension videoDimension() {
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = LibVlc.libvlc_video_get_size((libvlc_media_player_t)this.mediaPlayerInstance, (int)0, (IntByReference)px, (IntByReference)py);
        if (result == 0) {
            return new Dimension(px.getValue(), py.getValue());
        }
        return null;
    }

    public Viewpoint newViewpoint() {
        libvlc_video_viewpoint_t viewpoint = LibVlc.libvlc_video_new_viewpoint();
        if (viewpoint != null) {
            return new Viewpoint(viewpoint);
        }
        return null;
    }

    public boolean updateViewpoint(Viewpoint viewpoint, boolean absolute) {
        return LibVlc.libvlc_video_update_viewpoint((libvlc_media_player_t)this.mediaPlayerInstance, (libvlc_video_viewpoint_t)viewpoint.viewpoint(), (int)(absolute ? 1 : 0)) == 0;
    }

    public VideoStereoMode getVideoStereoMode() {
        return VideoStereoMode.videoStereoMode(LibVlc.libvlc_video_get_video_stereo_mode((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    public void setVideoStereoMode(VideoStereoMode videoStereoMode) {
        LibVlc.libvlc_video_set_video_stereo_mode((libvlc_media_player_t)this.mediaPlayerInstance, (int)videoStereoMode.intValue());
    }

    public Point getCursor() {
        return this.getCursor(0);
    }

    public Point getCursor(int videoNum) {
        IntByReference px = new IntByReference();
        IntByReference py = new IntByReference();
        int result = LibVlc.libvlc_video_get_cursor((libvlc_media_player_t)this.mediaPlayerInstance, (int)videoNum, (Pointer)px.getPointer(), (Pointer)py.getPointer());
        if (result == 0) {
            return new Point(px.getValue(), py.getValue());
        }
        return null;
    }
}

