/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component.callback;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import uk.co.caprica.vlcj.player.component.callback.BaseCallbackImagePainter;
import uk.co.caprica.vlcj.player.component.callback.CallbackImagePainter;

public class RotatedCallbackImagePainter
extends BaseCallbackImagePainter {
    private final CallbackImagePainter delegate;
    private volatile double angle;

    public RotatedCallbackImagePainter(CallbackImagePainter delegate) {
        this(delegate, 0.0);
    }

    public RotatedCallbackImagePainter(CallbackImagePainter delegate, double initialAngle) {
        this.delegate = delegate;
        this.angle = initialAngle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public void prepare(Graphics2D g2, JComponent component) {
        this.delegate.prepare(g2, component);
    }

    @Override
    public void paint(Graphics2D g2, JComponent component, BufferedImage image) {
        g2.setColor(component.getBackground());
        g2.fillRect(0, 0, component.getWidth(), component.getHeight());
        g2.rotate(this.angle, (double)component.getWidth() / 2.0, (double)component.getHeight() / 2.0);
        this.delegate.paint(g2, component, image);
    }
}

