/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component.callback;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import uk.co.caprica.vlcj.player.base.VideoTrack;
import uk.co.caprica.vlcj.player.component.callback.BaseCallbackImagePainter;

public class SampleAspectRatioCallbackImagePainter
extends BaseCallbackImagePainter {
    private volatile AspectRatio sar;

    @Override
    public void videoTrackChanged(VideoTrack videoTrack) {
        this.sar = videoTrack != null ? new AspectRatio(Math.max(1, videoTrack.sampleAspectRatio()), Math.max(videoTrack.sampleAspectRatioBase(), 1)) : null;
    }

    @Override
    public void prepare(Graphics2D g2, JComponent component) {
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    @Override
    public void paint(Graphics2D g2, JComponent component, BufferedImage image) {
        int width = component.getWidth();
        int height = component.getHeight();
        g2.setColor(component.getBackground());
        g2.fillRect(0, 0, width, height);
        if (image != null && this.sar != null) {
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            int adjustedImageWidth = imageWidth * this.sar.numerator / this.sar.denominator;
            float sx = (float)width / (float)adjustedImageWidth;
            float sy = (float)height / (float)imageHeight;
            float sf = Math.min(sx, sy);
            float scaledW = (float)adjustedImageWidth * sf;
            float scaledH = (float)imageHeight * sf;
            g2.translate(((float)width - scaledW) / 2.0f, ((float)height - scaledH) / 2.0f);
            AffineTransform savedTransform = g2.getTransform();
            g2.scale(sf * (float)this.sar.numerator / (float)this.sar.denominator, sf);
            g2.drawImage(image, null, 0, 0);
            g2.setTransform(savedTransform);
            g2.scale(sf, sf);
        }
    }

    private static class AspectRatio {
        private final int numerator;
        private final int denominator;

        private AspectRatio(int numerator, int denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }
    }
}

