/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_format_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_cleanup_cb;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.NativeBuffers;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public class CallbackVideoSurface
extends VideoSurface {
    private final libvlc_video_format_cb setup = new SetupCallback();
    private final libvlc_video_output_cleanup_cb cleanup = new CleanupCallback();
    private final libvlc_lock_callback_t lock = new LockCallback();
    private final libvlc_unlock_callback_t unlock = new UnlockCallback();
    private final libvlc_display_callback_t display = new DisplayCallback();
    private final BufferFormatCallback bufferFormatCallback;
    private final RenderCallback renderCallback;
    private final NativeBuffers nativeBuffers;
    private MediaPlayer mediaPlayer;
    private BufferFormat bufferFormat;
    private int displayWidth;
    private int displayHeight;

    public CallbackVideoSurface(BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback, boolean lockBuffers) {
        super(null);
        this.bufferFormatCallback = bufferFormatCallback;
        this.renderCallback = renderCallback;
        this.nativeBuffers = new NativeBuffers(lockBuffers);
    }

    @Override
    public void attach(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        LibVlc.libvlc_video_set_format_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_video_format_cb)this.setup, (libvlc_video_output_cleanup_cb)this.cleanup);
        LibVlc.libvlc_video_set_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_lock_callback_t)this.lock, (libvlc_unlock_callback_t)this.unlock, (libvlc_display_callback_t)this.display, null);
    }

    private final class SetupCallback
    implements libvlc_video_format_cb {
        private SetupCallback() {
        }

        public int format(PointerByReference opaque, PointerByReference chroma, Pointer width, Pointer height, PointerByReference pitches, PointerByReference lines) {
            int[] widthArray = width.getIntArray(0L, 2);
            int[] heightArray = height.getIntArray(0L, 2);
            int sourceWidth = widthArray[0];
            int sourceHeight = heightArray[0];
            CallbackVideoSurface.this.displayWidth = widthArray[1];
            CallbackVideoSurface.this.displayHeight = heightArray[1];
            CallbackVideoSurface.this.bufferFormat = CallbackVideoSurface.this.bufferFormatCallback.getBufferFormat(sourceWidth, sourceHeight);
            this.applyBufferFormat(CallbackVideoSurface.this.bufferFormat, chroma, width, height, pitches, lines);
            int result = CallbackVideoSurface.this.nativeBuffers.allocate(CallbackVideoSurface.this.bufferFormat);
            sourceWidth = width.getInt(0L);
            sourceHeight = height.getInt(0L);
            CallbackVideoSurface.this.bufferFormatCallback.newFormatSize(sourceWidth, sourceHeight, CallbackVideoSurface.this.displayWidth, CallbackVideoSurface.this.displayHeight);
            CallbackVideoSurface.this.bufferFormatCallback.allocatedBuffers(CallbackVideoSurface.this.nativeBuffers.buffers());
            return result;
        }

        private void applyBufferFormat(BufferFormat bufferFormat, PointerByReference chroma, Pointer width, Pointer height, PointerByReference pitches, PointerByReference lines) {
            byte[] chromaBytes = bufferFormat.getChroma().getBytes();
            chroma.getPointer().write(0L, chromaBytes, 0, chromaBytes.length < 4 ? chromaBytes.length : 4);
            width.setInt(0L, bufferFormat.getWidth());
            height.setInt(0L, bufferFormat.getHeight());
            int[] pitchValues = bufferFormat.getPitches();
            int[] lineValues = bufferFormat.getLines();
            pitches.getPointer().write(0L, pitchValues, 0, pitchValues.length);
            lines.getPointer().write(0L, lineValues, 0, lineValues.length);
        }
    }

    private final class CleanupCallback
    implements libvlc_video_output_cleanup_cb {
        private CleanupCallback() {
        }

        public void cleanup(Long opaque) {
            CallbackVideoSurface.this.nativeBuffers.free();
        }
    }

    private final class LockCallback
    implements libvlc_lock_callback_t {
        private LockCallback() {
        }

        public Pointer lock(Long opaque, PointerByReference planes) {
            Pointer[] pointers = CallbackVideoSurface.this.nativeBuffers.pointers();
            planes.getPointer().write(0L, pointers, 0, pointers.length);
            CallbackVideoSurface.this.renderCallback.lock(CallbackVideoSurface.this.mediaPlayer);
            return null;
        }
    }

    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        private UnlockCallback() {
        }

        public void unlock(Long opaque, Pointer picture, Pointer plane) {
            CallbackVideoSurface.this.renderCallback.unlock(CallbackVideoSurface.this.mediaPlayer);
        }
    }

    private final class DisplayCallback
    implements libvlc_display_callback_t {
        private DisplayCallback() {
        }

        public void display(Long opaque, Pointer picture) {
            CallbackVideoSurface.this.renderCallback.display(CallbackVideoSurface.this.mediaPlayer, CallbackVideoSurface.this.nativeBuffers.buffers(), CallbackVideoSurface.this.bufferFormat, CallbackVideoSurface.this.displayWidth, CallbackVideoSurface.this.displayHeight);
        }
    }
}

