/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface.videoengine;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_color_primaries_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_color_space_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_getProcAddress_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_makeCurrent_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_orient_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_cfg_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_mouse_move_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_mouse_press_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_mouse_release_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_resize_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_set_window_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_output_setup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_render_cfg_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_setup_device_cfg_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_setup_device_info_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_swap_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_transfer_func_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_update_output_cb;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MouseButton;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.videoengine.VideoEngine;
import uk.co.caprica.vlcj.player.embedded.videosurface.videoengine.VideoEngineCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.videoengine.VideoEngineWindowCallbackHandler;

public final class VideoEngineVideoSurface
extends VideoSurface {
    private static final int GL_RGBA = 6408;
    private final VideoEngine engine;
    private final VideoEngineCallback callback;
    private final libvlc_video_output_setup_cb setup = new SetupCallback();
    private final libvlc_video_output_cleanup_cb cleanup = new CleanupCallback();
    private final libvlc_video_output_set_window_cb setWindowCallback = new SetWindowCallback();
    private final libvlc_video_update_output_cb updateOutput = new UpdateOutputCallback();
    private final libvlc_video_swap_cb swap = new SwapCallback();
    private final libvlc_video_makeCurrent_cb makeCurrent = new MakeCurrentCallback();
    private final libvlc_video_getProcAddress_cb getProcAddress = new GetProcAddressCallback();
    private VideoEngineWindowCallbackHandler windowCallbackHandler;

    public VideoEngineVideoSurface(VideoEngine engine, VideoEngineCallback callback, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        this.engine = engine;
        this.callback = callback;
    }

    public void resize(int width, int height) {
        this.windowCallbackHandler.setSize(width, height);
    }

    public void mouseMoved(int x, int y) {
        this.windowCallbackHandler.mouseMoved(x, y);
    }

    public void mousePressed(MouseButton mouseButton) {
        this.windowCallbackHandler.mousePressed(mouseButton);
    }

    public void mouseReleased(MouseButton mouseButton) {
        this.windowCallbackHandler.mouseReleased(mouseButton);
    }

    @Override
    public void attach(MediaPlayer mediaPlayer) {
        LibVlc.libvlc_video_set_output_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (int)this.engine.intValue(), (libvlc_video_output_setup_cb)this.setup, (libvlc_video_output_cleanup_cb)this.cleanup, (libvlc_video_output_set_window_cb)this.setWindowCallback, (libvlc_video_update_output_cb)this.updateOutput, (libvlc_video_swap_cb)this.swap, (libvlc_video_makeCurrent_cb)this.makeCurrent, (libvlc_video_getProcAddress_cb)this.getProcAddress, null, null, null);
    }

    private final class SetupCallback
    implements libvlc_video_output_setup_cb {
        private SetupCallback() {
        }

        public int setup(Long opaque, libvlc_video_setup_device_cfg_t cfg, libvlc_video_setup_device_info_t out) {
            return VideoEngineVideoSurface.this.callback.onSetup(opaque, cfg, out) ? 1 : 0;
        }
    }

    private final class CleanupCallback
    implements libvlc_video_output_cleanup_cb {
        private CleanupCallback() {
        }

        public void cleanup(Long opaque) {
            VideoEngineVideoSurface.this.callback.onCleanup(opaque);
        }
    }

    private final class SetWindowCallback
    implements libvlc_video_output_set_window_cb {
        private SetWindowCallback() {
        }

        public void setWindowCallback(Pointer opaque, libvlc_video_output_resize_cb report_size_change, libvlc_video_output_mouse_move_cb report_mouse_move, libvlc_video_output_mouse_press_cb report_mouse_pressed, libvlc_video_output_mouse_release_cb report_mouse_released, Pointer report_opaque) {
            VideoEngineVideoSurface.this.windowCallbackHandler = new VideoEngineWindowCallbackHandler(Pointer.nativeValue((Pointer)opaque), Pointer.nativeValue((Pointer)report_opaque), report_size_change, report_mouse_move, report_mouse_pressed, report_mouse_released);
            VideoEngineVideoSurface.this.callback.onSetWindowCallback(VideoEngineVideoSurface.this.windowCallbackHandler);
        }
    }

    private class UpdateOutputCallback
    implements libvlc_video_update_output_cb {
        private UpdateOutputCallback() {
        }

        public int updateOutput(Long opaque, libvlc_video_render_cfg_t cfg, libvlc_video_output_cfg_t output) {
            output.u.writeField("opengl_format", (Object)6408);
            output.full_range = 1;
            output.colorspace = libvlc_video_color_space_e.libvlc_video_colorspace_BT709.intValue();
            output.primaries = libvlc_video_color_primaries_e.libvlc_video_primaries_BT709.intValue();
            output.transfer = libvlc_video_transfer_func_e.libvlc_video_transfer_func_SRGB.intValue();
            output.orientation = libvlc_video_orient_t.libvlc_video_orient_top_left.intValue();
            return VideoEngineVideoSurface.this.callback.onUpdateOutput(opaque, cfg, output) ? 1 : 0;
        }
    }

    private class SwapCallback
    implements libvlc_video_swap_cb {
        private SwapCallback() {
        }

        public void swap(Long opaque) {
            VideoEngineVideoSurface.this.callback.onSwap(opaque);
        }
    }

    private class MakeCurrentCallback
    implements libvlc_video_makeCurrent_cb {
        private MakeCurrentCallback() {
        }

        public int makeCurrent(Long opaque, int enter) {
            return VideoEngineVideoSurface.this.callback.onMakeCurrent(opaque, enter != 0) ? 1 : 0;
        }
    }

    private class GetProcAddressCallback
    implements libvlc_video_getProcAddress_cb {
        private GetProcAddressCallback() {
        }

        public Pointer getProcAddress(Long opaque, String fct_name) {
            return Pointer.createConstant((long)VideoEngineVideoSurface.this.callback.onGetProcAddress(opaque, fct_name));
        }
    }
}

