/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectReader;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.responses.ResponseStatus;
import info.movito.themoviedbapi.model.core.responses.TmdbResponseException;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.TmdbResponseCode;
import info.movito.themoviedbapi.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTmdbApi {
    public static final String PARAM_YEAR = "year";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_ADULT = "include_adult";
    public static final String PARAM_SORT_BY = "sort_by";
    private static final ObjectReader RESPONSE_STATUS_READER = JsonUtil.OBJECT_MAPPER.readerFor(ResponseStatus.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTmdbApi.class);
    private final TmdbApi tmdbApi;

    AbstractTmdbApi(TmdbApi tmdbApi) {
        this.tmdbApi = tmdbApi;
    }

    protected <T> T mapJsonResult(ApiUrl apiUrl, Class<T> clazz) throws TmdbException {
        return this.mapJsonResult(apiUrl, null, clazz);
    }

    protected <T> T mapJsonResult(ApiUrl apiUrl, TypeReference<T> resultClass) throws TmdbException {
        return this.mapJsonResult(apiUrl, null, resultClass);
    }

    protected <T> T mapJsonResult(ApiUrl apiUrl, String jsonBody, Class<T> clazz) throws TmdbException {
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.GET, clazz);
    }

    protected <T> T mapJsonResult(ApiUrl apiUrl, String jsonBody, TypeReference<T> resultClass) throws TmdbException {
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.GET, resultClass);
    }

    protected <T> T mapJsonResult(ApiUrl apiUrl, String jsonBody, RequestType requestType, Class<T> clazz) throws TmdbException {
        return this.mapJsonResult(apiUrl, jsonBody, requestType, JsonUtil.OBJECT_MAPPER.readerFor(clazz));
    }

    protected <T> T mapJsonResult(ApiUrl apiUrl, String jsonBody, RequestType requestType, TypeReference<T> resultClass) throws TmdbException {
        return this.mapJsonResult(apiUrl, jsonBody, requestType, JsonUtil.OBJECT_MAPPER.readerFor(resultClass));
    }

    private <T> T mapJsonResult(ApiUrl apiUrl, String jsonBody, RequestType requestType, ObjectReader objectReader) throws TmdbException {
        String jsonResponse = this.tmdbApi.getTmdbUrlReader().readUrl(apiUrl.buildUrl(), jsonBody, requestType);
        try {
            ResponseStatus responseStatus = (ResponseStatus)RESPONSE_STATUS_READER.readValue(jsonResponse);
            TmdbResponseCode tmdbResponseCode = responseStatus.getStatusCode();
            if (tmdbResponseCode != null) {
                if (TmdbResponseCode.REQUEST_LIMIT_EXCEEDED == tmdbResponseCode) {
                    LOGGER.info("TMDB API: Request limit exceeded. Waiting 1 second before retrying.");
                    Thread.sleep(1000L);
                    return this.mapJsonResult(apiUrl, jsonBody, requestType, objectReader);
                }
                if (!tmdbResponseCode.isSuccess()) {
                    throw new TmdbResponseException(tmdbResponseCode);
                }
            }
        }
        catch (JsonProcessingException responseStatus) {
        }
        catch (InterruptedException exception) {
            throw new TmdbException(exception);
        }
        try {
            return (T)objectReader.readValue(jsonResponse);
        }
        catch (JsonProcessingException exception) {
            throw new TmdbException((Exception)((Object)exception));
        }
    }
}

