/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.account.Account;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.TvSeriesResultsPage;
import info.movito.themoviedbapi.model.core.responses.ResponseStatus;
import info.movito.themoviedbapi.model.movies.MovieListResultsPage;
import info.movito.themoviedbapi.model.rated.RatedMovieResultsPage;
import info.movito.themoviedbapi.model.rated.RatedTvEpisodeResultsPage;
import info.movito.themoviedbapi.model.rated.RatedTvSeriesResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.sortby.AccountSortBy;
import info.movito.themoviedbapi.util.JsonUtil;
import java.util.HashMap;

public class TmdbAccount
extends AbstractTmdbApi {
    public static final String PARAM_SESSION = "session_id";
    protected static final String TMDB_METHOD_ACCOUNT = "account";

    TmdbAccount(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public Account getDetails(Integer accountId, String sessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId);
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        return this.mapJsonResult(apiUrl, Account.class);
    }

    public ResponseStatus addFavorite(Integer accountId, String sessionId, Integer mediaId, MediaType mediaType) throws TmdbException {
        return this.changeFavoriteStatus(accountId, sessionId, mediaId, mediaType, true);
    }

    public ResponseStatus removeFavorite(Integer accountId, String sessionId, Integer mediaId, MediaType mediaType) throws TmdbException {
        return this.changeFavoriteStatus(accountId, sessionId, mediaId, mediaType, false);
    }

    private ResponseStatus changeFavoriteStatus(Integer accountId, String sessionId, Integer mediaId, MediaType mediaType, boolean isFavorite) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "favorite");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("media_type", mediaType.toString());
        body.put("media_id", mediaId);
        body.put("favorite", isFavorite);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }

    public ResponseStatus addToWatchList(Integer accountId, String sessionId, Integer mediaId, MediaType mediaType) throws TmdbException {
        return this.changeWatchListStatus(accountId, sessionId, mediaId, mediaType, true);
    }

    public ResponseStatus removeFromWatchList(Integer accountId, String sessionId, Integer mediaId, MediaType mediaType) throws TmdbException {
        return this.changeWatchListStatus(accountId, sessionId, mediaId, mediaType, false);
    }

    private ResponseStatus changeWatchListStatus(Integer accountId, String sessionId, Integer mediaId, MediaType mediaType, boolean isWatchList) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "watchlist");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("media_type", mediaType.toString());
        body.put("media_id", mediaId);
        body.put("watchlist", isWatchList);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }

    public MovieResultsPage getFavoriteMovies(Integer accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "favorite/movies");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public TvSeriesResultsPage getFavoriteTv(Integer accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "favorite/tv");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, TvSeriesResultsPage.class);
    }

    public MovieListResultsPage getLists(Integer accountId, String sessionId, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "lists");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieListResultsPage.class);
    }

    public RatedMovieResultsPage getRatedMovies(int accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "rated/movies");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, RatedMovieResultsPage.class);
    }

    public RatedTvSeriesResultsPage getRatedTvSeries(int accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "rated/tv");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, RatedTvSeriesResultsPage.class);
    }

    public RatedTvEpisodeResultsPage getRatedTvEpisodes(int accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "rated/tv/episodes");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, RatedTvEpisodeResultsPage.class);
    }

    public MovieResultsPage getWatchListMovies(Integer accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "watchlist/movies");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public TvSeriesResultsPage getWatchListTvSeries(Integer accountId, String sessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_ACCOUNT, accountId, "watchlist/tv");
        apiUrl.addQueryParam(PARAM_SESSION, sessionId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, TvSeriesResultsPage.class);
    }

    public static enum MediaType {
        MOVIE,
        TV;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

