/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.authentication.GuestSession;
import info.movito.themoviedbapi.model.authentication.RequestToken;
import info.movito.themoviedbapi.model.authentication.Session;
import info.movito.themoviedbapi.model.core.responses.ResponseStatusAuthentication;
import info.movito.themoviedbapi.model.core.responses.ResponseStatusDelete;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.util.JsonUtil;
import java.util.HashMap;

public class TmdbAuthentication
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_AUTH = "authentication";
    private static final String PARAM_REQUEST_TOKEN = "request_token";

    TmdbAuthentication(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public GuestSession createGuestSession() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "guest_session/new");
        return this.mapJsonResult(apiUrl, GuestSession.class);
    }

    public RequestToken createRequestToken() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "token/new");
        return this.mapJsonResult(apiUrl, RequestToken.class);
    }

    public static String getTmdbAuthenticationUrlForRequestToken(RequestToken token, String redirectUrl) throws TmdbException {
        if (token == null || !token.getSuccess().booleanValue()) {
            throw new TmdbException("Invalid request token! The request token must not be null and must be successful!");
        }
        StringBuilder sb = new StringBuilder("https://www.themoviedb.org/authenticate/");
        sb.append(token.getRequestToken());
        if (redirectUrl != null && !redirectUrl.trim().isEmpty()) {
            sb.append("?redirect_to=").append(redirectUrl);
        }
        return sb.toString();
    }

    public RequestToken createAuthenticatedRequestToken(RequestToken token, String username, String password) throws TmdbException {
        if (token == null || !token.getSuccess().booleanValue()) {
            throw new TmdbException("Invalid request token! The request token must not be null and must be successful!");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "token/validate_with_login");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("username", username);
        body.put("password", password);
        body.put(PARAM_REQUEST_TOKEN, token.getRequestToken());
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, RequestToken.class);
    }

    public Session createSession(RequestToken token) throws TmdbException {
        if (token == null || !token.getSuccess().booleanValue()) {
            throw new TmdbException("Invalid request token! The request token must not be null and must be successful!");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "session/new");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(PARAM_REQUEST_TOKEN, token.getRequestToken());
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, Session.class);
    }

    public ResponseStatusDelete deleteSession(String sessionId) throws TmdbException {
        if (sessionId == null || sessionId.trim().isEmpty()) {
            throw new TmdbException("Invalid session id! The session id must not be null or empty!");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "session");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("session_id", sessionId);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.DELETE, ResponseStatusDelete.class);
    }

    public ResponseStatusAuthentication validateKey() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH);
        return this.mapJsonResult(apiUrl, ResponseStatusAuthentication.class);
    }
}

