/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.changes.ChangesResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class TmdbChanges
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_CHANGES = "changes";
    protected static final String TMDB_METHOD_MOVIE = "movie";
    protected static final String TMDB_METHOD_PERSON = "person";
    protected static final String TMDB_METHOD_TV = "tv";

    TmdbChanges(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public ChangesResultsPage getMovieChangesList(String startDate, String endDate, Integer page) throws TmdbException {
        if (TmdbChanges.calculateDaysDifference(startDate, endDate) > 14L) {
            throw new IllegalArgumentException("The date range must be less than or equal to 14 days.");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, TMDB_METHOD_CHANGES);
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangesResultsPage.class);
    }

    public ChangesResultsPage getPeopleChangesList(String startDate, String endDate, Integer page) throws TmdbException {
        if (TmdbChanges.calculateDaysDifference(startDate, endDate) > 14L) {
            throw new IllegalArgumentException("The date range must be less than or equal to 14 days.");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, TMDB_METHOD_CHANGES);
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangesResultsPage.class);
    }

    public ChangesResultsPage getTvChangesList(String startDate, String endDate, Integer page) throws TmdbException {
        if (TmdbChanges.calculateDaysDifference(startDate, endDate) > 14L) {
            throw new IllegalArgumentException("The date range must be less than or equal to 14 days.");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, TMDB_METHOD_CHANGES);
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangesResultsPage.class);
    }

    private static long calculateDaysDifference(String startDateString, String endDateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate startDate = LocalDate.parse(startDateString, formatter);
        LocalDate endDate = LocalDate.parse(endDateString, formatter);
        return ChronoUnit.DAYS.between(startDate, endDate);
    }
}

