/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.collections.CollectionInfo;
import info.movito.themoviedbapi.model.collections.Images;
import info.movito.themoviedbapi.model.collections.Translation;
import info.movito.themoviedbapi.model.collections.Translations;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import java.util.List;

public class TmdbCollections
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_COLLECTION = "collection";

    TmdbCollections(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public CollectionInfo getDetails(Integer collectionId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COLLECTION, collectionId);
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, CollectionInfo.class);
    }

    public Images getImages(Integer collectionId, String language, String ... includeImageLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COLLECTION, collectionId, "images");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_image_language", includeImageLanguage);
        return this.mapJsonResult(apiUrl, Images.class);
    }

    public List<Translation> getTranslations(Integer collectionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COLLECTION, collectionId, "translations");
        return this.mapJsonResult(apiUrl, Translations.class).getTranslations();
    }
}

