/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import com.fasterxml.jackson.core.type.TypeReference;
import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.configuration.Configuration;
import info.movito.themoviedbapi.model.configuration.Country;
import info.movito.themoviedbapi.model.configuration.Job;
import info.movito.themoviedbapi.model.configuration.Timezone;
import info.movito.themoviedbapi.model.core.Language;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import java.util.List;

public class TmdbConfiguration
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_CONFIGURATION = "configuration";

    TmdbConfiguration(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public Configuration getDetails() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_CONFIGURATION);
        return this.mapJsonResult(apiUrl, Configuration.class);
    }

    public List<Country> getCountries(String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_CONFIGURATION, "countries");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, new TypeReference<List<Country>>(this){});
    }

    public List<Job> getJobs() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_CONFIGURATION, "jobs");
        return this.mapJsonResult(apiUrl, new TypeReference<List<Job>>(this){});
    }

    public List<Language> getLanguages() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_CONFIGURATION, "languages");
        return this.mapJsonResult(apiUrl, new TypeReference<List<Language>>(this){});
    }

    public List<String> getPrimaryTranslations() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_CONFIGURATION, "primary_translations");
        return this.mapJsonResult(apiUrl, new TypeReference<List<String>>(this){});
    }

    public List<Timezone> getTimezones() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_CONFIGURATION, "timezones");
        return this.mapJsonResult(apiUrl, new TypeReference<List<Timezone>>(this){});
    }
}

