/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.rated.RatedMovieResultsPage;
import info.movito.themoviedbapi.model.rated.RatedTvEpisodeResultsPage;
import info.movito.themoviedbapi.model.rated.RatedTvSeriesResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.sortby.AccountSortBy;

public class TmdbGuestSessions
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_GUEST_SESSIONS = "guest_session";

    public TmdbGuestSessions(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public RatedMovieResultsPage getRatedMovies(int guestSessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_GUEST_SESSIONS, guestSessionId, "rated/movies");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, RatedMovieResultsPage.class);
    }

    public RatedTvSeriesResultsPage getRatedTvSeries(int guestSessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_GUEST_SESSIONS, guestSessionId, "rated/tv");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, RatedTvSeriesResultsPage.class);
    }

    public RatedTvEpisodeResultsPage getRatedTvEpisodes(int guestSessionId, String language, Integer page, AccountSortBy sortBy) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_GUEST_SESSIONS, guestSessionId, "rated/tv/episodes");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addSortBy(sortBy);
        return this.mapJsonResult(apiUrl, RatedTvEpisodeResultsPage.class);
    }
}

