/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.responses.ResponseStatus;
import info.movito.themoviedbapi.model.lists.ListDetails;
import info.movito.themoviedbapi.model.lists.ListItemStatus;
import info.movito.themoviedbapi.model.lists.MovieListCreationStatus;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.util.JsonUtil;
import java.util.HashMap;

public class TmdbLists
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_LIST = "list";

    public TmdbLists(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public ResponseStatus addMovie(Integer listId, String sessionId, Integer movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId, "add_item");
        apiUrl.addPathParam("session_id", sessionId);
        HashMap<String, Integer> body = new HashMap<String, Integer>();
        body.put("media_id", movieId);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }

    public ListItemStatus checkItemStatus(Integer listId, String language, Integer movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId, "item_status");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParam("movie_id", movieId);
        return this.mapJsonResult(apiUrl, ListItemStatus.class);
    }

    public ResponseStatus clear(Integer listId, String sessionId, Boolean confirm) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId, "clear");
        apiUrl.addPathParam("session_id", sessionId);
        apiUrl.addPathParam("confirm", confirm);
        return this.mapJsonResult(apiUrl, null, RequestType.POST, ResponseStatus.class);
    }

    public MovieListCreationStatus create(String sessionId, String name, String description, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST);
        apiUrl.addPathParam("session_id", sessionId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("name", name);
        body.put("description", description);
        body.put("language", language);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, MovieListCreationStatus.class);
    }

    public ResponseStatus delete(Integer listId, String sessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId);
        apiUrl.addPathParam("session_id", sessionId);
        return this.mapJsonResult(apiUrl, null, RequestType.DELETE, ResponseStatus.class);
    }

    public ListDetails getDetails(Integer listId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ListDetails.class);
    }

    public ResponseStatus removeMovie(Integer listId, String sessionId, Integer movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId, "remove_item");
        apiUrl.addPathParam("session_id", sessionId);
        HashMap<String, Integer> body = new HashMap<String, Integer>();
        body.put("media_id", movieId);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }
}

