/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.movielists.MovieResultsPageWithDates;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;

public class TmdbMovieLists
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_MOVIE_LISTS = "movie";

    TmdbMovieLists(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public MovieResultsPageWithDates getNowPlaying(String language, Integer page, String region) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE_LISTS, "now_playing");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addQueryParam("region", region);
        return this.mapJsonResult(apiUrl, MovieResultsPageWithDates.class);
    }

    public MovieResultsPage getPopular(String language, Integer page, String region) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE_LISTS, "popular");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addQueryParam("region", region);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public MovieResultsPage getTopRated(String language, Integer page, String region) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE_LISTS, "top_rated");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addQueryParam("region", region);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public MovieResultsPageWithDates getUpcoming(String language, Integer page, String region) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE_LISTS, "upcoming");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        apiUrl.addQueryParam("region", region);
        return this.mapJsonResult(apiUrl, MovieResultsPageWithDates.class);
    }
}

