/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.AccountStates;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.ReviewResultsPage;
import info.movito.themoviedbapi.model.core.responses.ResponseStatus;
import info.movito.themoviedbapi.model.core.video.VideoResults;
import info.movito.themoviedbapi.model.core.watchproviders.ProviderResults;
import info.movito.themoviedbapi.model.movies.AlternativeTitles;
import info.movito.themoviedbapi.model.movies.Credits;
import info.movito.themoviedbapi.model.movies.ExternalIds;
import info.movito.themoviedbapi.model.movies.Images;
import info.movito.themoviedbapi.model.movies.KeywordResults;
import info.movito.themoviedbapi.model.movies.MovieDb;
import info.movito.themoviedbapi.model.movies.MovieListResultsPage;
import info.movito.themoviedbapi.model.movies.ReleaseDateResults;
import info.movito.themoviedbapi.model.movies.Translations;
import info.movito.themoviedbapi.model.movies.changes.ChangeResults;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.appendtoresponse.MovieAppendToResponse;
import info.movito.themoviedbapi.util.JsonUtil;
import java.util.HashMap;

public class TmdbMovies
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_MOVIE = "movie";

    public TmdbMovies(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public MovieDb getDetails(int movieId, String language, MovieAppendToResponse ... appendToResponse) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId);
        apiUrl.addLanguage(language);
        apiUrl.addAppendToResponses(appendToResponse);
        return this.mapJsonResult(apiUrl, MovieDb.class);
    }

    public AccountStates getAccountStates(int movieId, String sessionId, String guestSessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "account_states");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, AccountStates.class);
    }

    public AlternativeTitles getAlternativeTitles(int movieId, String country) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "alternative_titles");
        apiUrl.addQueryParam("country", country);
        return this.mapJsonResult(apiUrl, AlternativeTitles.class);
    }

    public ChangeResults getChanges(int movieId, String startDate, String endDate, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "changes");
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangeResults.class);
    }

    public Credits getCredits(int movieId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Credits.class);
    }

    public ExternalIds getExternalIds(int movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "external_ids");
        return this.mapJsonResult(apiUrl, ExternalIds.class);
    }

    public Images getImages(int movieId, String language, String ... includeImageLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "images");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_image_language", includeImageLanguage);
        return this.mapJsonResult(apiUrl, Images.class);
    }

    public KeywordResults getKeywords(int movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "keywords");
        return this.mapJsonResult(apiUrl, KeywordResults.class);
    }

    public MovieDb getLatest() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, "latest");
        return this.mapJsonResult(apiUrl, MovieDb.class);
    }

    public MovieListResultsPage getLists(int movieId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "lists");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieListResultsPage.class);
    }

    public MovieResultsPage getRecommendations(int movieId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "recommendations");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public ReleaseDateResults getReleaseDates(int movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "release_dates");
        return this.mapJsonResult(apiUrl, ReleaseDateResults.class);
    }

    public ReviewResultsPage getReviews(int movieId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "reviews");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ReviewResultsPage.class);
    }

    public MovieResultsPage getSimilar(int movieId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "similar");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public Translations getTranslations(int movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "translations");
        return this.mapJsonResult(apiUrl, Translations.class);
    }

    public VideoResults getVideos(int movieId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "videos");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, VideoResults.class);
    }

    public ProviderResults getWatchProviders(int movieId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "watch/providers");
        return this.mapJsonResult(apiUrl, ProviderResults.class);
    }

    public ResponseStatus addRating(int movieId, String guestSessionId, String sessionId, double rating) throws TmdbException {
        if (rating < 0.0 || rating > 10.0) {
            throw new IllegalArgumentException("Rating must be: 0 < rating <= 10");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "rating");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        HashMap<String, Double> body = new HashMap<String, Double>();
        body.put("value", rating);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }

    public ResponseStatus deleteRating(int movieId, String guestSessionId, String sessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_MOVIE, movieId, "rating");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, null, RequestType.DELETE, ResponseStatus.class);
    }
}

