/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.image.ImageResults;
import info.movito.themoviedbapi.model.networks.AlternativeNamesResults;
import info.movito.themoviedbapi.model.networks.Network;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;

public class TmdbNetworks
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_NETWORK = "network";

    public TmdbNetworks(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public Network getDetails(int networkId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_NETWORK, networkId);
        return this.mapJsonResult(apiUrl, Network.class);
    }

    public AlternativeNamesResults getAlternativeNames(int networkId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_NETWORK, networkId, "alternative_names");
        return this.mapJsonResult(apiUrl, AlternativeNamesResults.class);
    }

    public ImageResults getImages(int networkId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_NETWORK, networkId, "images");
        return this.mapJsonResult(apiUrl, ImageResults.class);
    }
}

