/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.movies.changes.ChangeResults;
import info.movito.themoviedbapi.model.people.ExternalIds;
import info.movito.themoviedbapi.model.people.PersonDb;
import info.movito.themoviedbapi.model.people.PersonImages;
import info.movito.themoviedbapi.model.people.Translations;
import info.movito.themoviedbapi.model.people.credits.CombinedPersonCredits;
import info.movito.themoviedbapi.model.people.credits.MovieCredits;
import info.movito.themoviedbapi.model.people.credits.TvCredits;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.appendtoresponse.PersonAppendToResponse;

public class TmdbPeople
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_PERSON = "person";

    TmdbPeople(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public PersonDb getDetails(int personId, String language, PersonAppendToResponse ... appendToResponse) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId);
        apiUrl.addLanguage(language);
        apiUrl.addAppendToResponses(appendToResponse);
        return this.mapJsonResult(apiUrl, PersonDb.class);
    }

    public ChangeResults getChanges(int personId, String startDate, String endDate, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "changes");
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangeResults.class);
    }

    public CombinedPersonCredits getCombinedCredits(int personId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "combined_credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, CombinedPersonCredits.class);
    }

    public ExternalIds getExternalIds(int personId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "external_ids");
        return this.mapJsonResult(apiUrl, ExternalIds.class);
    }

    public PersonImages getImages(int personId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "images");
        return this.mapJsonResult(apiUrl, PersonImages.class);
    }

    public PersonDb getLatest() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, "latest");
        return this.mapJsonResult(apiUrl, PersonDb.class);
    }

    public MovieCredits getMovieCredits(int personId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "movie_credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, MovieCredits.class);
    }

    public TvCredits getTvCredits(int personId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "tv_credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, TvCredits.class);
    }

    public Translations getTranslations(int personId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_PERSON, personId, "translations");
        return this.mapJsonResult(apiUrl, Translations.class);
    }
}

