/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.TvSeriesResultsPage;
import info.movito.themoviedbapi.model.core.multi.MultiResultsPage;
import info.movito.themoviedbapi.model.core.popularperson.PopularPersonResultsPage;
import info.movito.themoviedbapi.model.search.CollectionResultsPage;
import info.movito.themoviedbapi.model.search.CompanyResultsPage;
import info.movito.themoviedbapi.model.search.KeywordResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;

public class TmdbSearch
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_SEARCH = "search";
    protected static final String TMDB_METHOD_MULTI = "multi";
    private static final String PARAM_QUERY = "query";

    public TmdbSearch(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public CollectionResultsPage searchCollection(String query, String language, Boolean includeAdult, Integer page, String region) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "collection");
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addQueryParam("include_adult", includeAdult);
        apiUrl.addQueryParam("region", region);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, CollectionResultsPage.class);
    }

    public CompanyResultsPage searchCompany(String query, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "company");
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, CompanyResultsPage.class);
    }

    public KeywordResultsPage searchKeyword(String query, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "keyword");
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, KeywordResultsPage.class);
    }

    public MovieResultsPage searchMovie(String query, Boolean includeAdult, String language, String primaryReleaseYear, Integer page, String region, String year) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "movie");
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addQueryParam("include_adult", includeAdult);
        apiUrl.addQueryParam("primary_release_year", primaryReleaseYear);
        apiUrl.addQueryParam("region", region);
        apiUrl.addQueryParam("year", year);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public MultiResultsPage searchMulti(String query, Boolean includeAdult, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, TMDB_METHOD_MULTI);
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addQueryParam("include_adult", includeAdult);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MultiResultsPage.class);
    }

    public PopularPersonResultsPage searchPerson(String query, Boolean includeAdult, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "person");
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addQueryParam("include_adult", includeAdult);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, PopularPersonResultsPage.class);
    }

    public TvSeriesResultsPage searchTv(String query, Integer firstAirDateYear, Boolean includeAdult, String language, Integer page, Integer year) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "tv");
        apiUrl.addPathParam(PARAM_QUERY, query);
        apiUrl.addQueryParam("first_air_date_year", firstAirDateYear);
        apiUrl.addQueryParam("include_adult", includeAdult);
        apiUrl.addQueryParam("year", year);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvSeriesResultsPage.class);
    }
}

