/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.TvSeriesResultsPage;
import info.movito.themoviedbapi.model.core.multi.MultiResultsPage;
import info.movito.themoviedbapi.model.core.popularperson.PopularPersonResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.model.time.TimeWindow;

public class TmdbTrending
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_TRENDING = "trending";

    TmdbTrending(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public MultiResultsPage getAll(TimeWindow timeWindow, String language) throws TmdbException {
        return this.getAll(timeWindow, language, 1);
    }

    public MultiResultsPage getAll(TimeWindow timeWindow, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TRENDING, "all", timeWindow.getValue());
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MultiResultsPage.class);
    }

    public MovieResultsPage getMovies(TimeWindow timeWindow, String language) throws TmdbException {
        return this.getMovies(timeWindow, language, 1);
    }

    public MovieResultsPage getMovies(TimeWindow timeWindow, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TRENDING, "movie", timeWindow.getValue());
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public PopularPersonResultsPage getPeople(TimeWindow timeWindow, String language) throws TmdbException {
        return this.getPeople(timeWindow, language, 1);
    }

    public PopularPersonResultsPage getPeople(TimeWindow timeWindow, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TRENDING, "person", timeWindow.getValue());
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, PopularPersonResultsPage.class);
    }

    public TvSeriesResultsPage getTv(TimeWindow timeWindow, String language) throws TmdbException {
        return this.getTv(timeWindow, language, 1);
    }

    public TvSeriesResultsPage getTv(TimeWindow timeWindow, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TRENDING, "tv", timeWindow.getValue());
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvSeriesResultsPage.class);
    }
}

