/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.AccountStates;
import info.movito.themoviedbapi.model.core.responses.ResponseStatus;
import info.movito.themoviedbapi.model.core.video.VideoResults;
import info.movito.themoviedbapi.model.tv.core.ChangeResults;
import info.movito.themoviedbapi.model.tv.core.Translations;
import info.movito.themoviedbapi.model.tv.episode.EpisodeCredits;
import info.movito.themoviedbapi.model.tv.episode.ExternalIds;
import info.movito.themoviedbapi.model.tv.episode.Images;
import info.movito.themoviedbapi.model.tv.episode.TvEpisodeDb;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.appendtoresponse.TvEpisodesAppendToResponse;
import info.movito.themoviedbapi.util.JsonUtil;
import java.util.HashMap;

public class TmdbTvEpisodes
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_TV_EPISODE = "episode";

    TmdbTvEpisodes(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public TvEpisodeDb getDetails(int seriesId, int seasonNumber, int episodeNumber, String language, TvEpisodesAppendToResponse ... appendToResponse) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber);
        apiUrl.addLanguage(language);
        apiUrl.addAppendToResponses(appendToResponse);
        return this.mapJsonResult(apiUrl, TvEpisodeDb.class);
    }

    public AccountStates getAccountStates(int seriesId, int seasonNumber, int episodeNumber, String sessionId, String guestSessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "account_states");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, AccountStates.class);
    }

    public ChangeResults getChanges(int episodeId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", TMDB_METHOD_TV_EPISODE, episodeId, "changes");
        return this.mapJsonResult(apiUrl, ChangeResults.class);
    }

    public EpisodeCredits getCredits(int seriesId, int seasonNumber, int episodeNumber, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, EpisodeCredits.class);
    }

    public ExternalIds getExternalIds(int seriesId, int seasonNumber, int episodeNumber) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "external_ids");
        return this.mapJsonResult(apiUrl, ExternalIds.class);
    }

    public Images getImages(int seriesId, int seasonNumber, int episodeNumber, String language, String ... includeImageLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "images");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_image_language", includeImageLanguage);
        return this.mapJsonResult(apiUrl, Images.class);
    }

    public Translations getTranslations(int seriesId, int seasonNumber, int episodeNumber) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "translations");
        return this.mapJsonResult(apiUrl, Translations.class);
    }

    public VideoResults getVideos(int seriesId, int seasonNumber, int episodeNumber, String language, String ... includeVideoLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "videos");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_video_language", includeVideoLanguage);
        return this.mapJsonResult(apiUrl, VideoResults.class);
    }

    public ResponseStatus addRating(int seriesId, int seasonNumber, int episodeNumber, String guestSessionId, String sessionId, double rating) throws TmdbException {
        if (rating < 0.0 || rating > 10.0) {
            throw new IllegalArgumentException("Rating must be: 0 < rating <= 10");
        }
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "rating");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        HashMap<String, Double> body = new HashMap<String, Double>();
        body.put("value", rating);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }

    public ResponseStatus deleteRating(int seriesId, int seasonNumber, int episodeNumber, String guestSessionId, String sessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, "season", seasonNumber, TMDB_METHOD_TV_EPISODE, episodeNumber, "rating");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, null, RequestType.DELETE, ResponseStatus.class);
    }
}

