/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.video.VideoResults;
import info.movito.themoviedbapi.model.core.watchproviders.ProviderResults;
import info.movito.themoviedbapi.model.tv.core.Translations;
import info.movito.themoviedbapi.model.tv.core.credits.AggregateCredits;
import info.movito.themoviedbapi.model.tv.core.credits.Credits;
import info.movito.themoviedbapi.model.tv.season.AccountStateResults;
import info.movito.themoviedbapi.model.tv.season.ChangeResults;
import info.movito.themoviedbapi.model.tv.season.ExternalIds;
import info.movito.themoviedbapi.model.tv.season.Images;
import info.movito.themoviedbapi.model.tv.season.TvSeasonDb;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.appendtoresponse.TvSeasonsAppendToResponse;

public class TmdbTvSeasons
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_TV_SEASON = "season";

    TmdbTvSeasons(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public TvSeasonDb getDetails(int seriesId, int seasonNumber, String language, TvSeasonsAppendToResponse ... appendToResponse) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber);
        apiUrl.addLanguage(language);
        apiUrl.addAppendToResponses(appendToResponse);
        return this.mapJsonResult(apiUrl, TvSeasonDb.class);
    }

    public AccountStateResults getAccountStates(int seriesId, int seasonNumber, String sessionId, String guestSessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "account_states");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, AccountStateResults.class);
    }

    public AggregateCredits getAggregateCredits(int seriesId, int seasonNumber, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "aggregate_credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, AggregateCredits.class);
    }

    public ChangeResults getChanges(int seasonId, String startDate, String endDate, int page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", TMDB_METHOD_TV_SEASON, seasonId, "changes");
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangeResults.class);
    }

    public Credits getCredits(int seriesId, int seasonNumber, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Credits.class);
    }

    public ExternalIds getExternalIds(int seriesId, int seasonNumber) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "external_ids");
        return this.mapJsonResult(apiUrl, ExternalIds.class);
    }

    public Images getImages(int seriesId, int seasonNumber, String language, String ... includeImageLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "images");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_image_language", includeImageLanguage);
        return this.mapJsonResult(apiUrl, Images.class);
    }

    public Translations getTranslations(int seriesId, int seasonNumber) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "translations");
        return this.mapJsonResult(apiUrl, Translations.class);
    }

    public VideoResults getVideos(int seriesId, int seasonNumber, String language, String ... includeVideoLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "videos");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_video_language", includeVideoLanguage);
        return this.mapJsonResult(apiUrl, VideoResults.class);
    }

    public ProviderResults getWatchProviders(int seriesId, int seasonNumber, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl("tv", seriesId, TMDB_METHOD_TV_SEASON, seasonNumber, "watch/providers");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, ProviderResults.class);
    }
}

