/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.AccountStates;
import info.movito.themoviedbapi.model.core.ReviewResultsPage;
import info.movito.themoviedbapi.model.core.TvKeywords;
import info.movito.themoviedbapi.model.core.TvSeriesResultsPage;
import info.movito.themoviedbapi.model.core.responses.ResponseStatus;
import info.movito.themoviedbapi.model.core.video.VideoResults;
import info.movito.themoviedbapi.model.core.watchproviders.ProviderResults;
import info.movito.themoviedbapi.model.tv.core.ChangeResults;
import info.movito.themoviedbapi.model.tv.core.credits.AggregateCredits;
import info.movito.themoviedbapi.model.tv.core.credits.Credits;
import info.movito.themoviedbapi.model.tv.series.AlternativeTitleResults;
import info.movito.themoviedbapi.model.tv.series.ContentRatingResults;
import info.movito.themoviedbapi.model.tv.series.EpisodeGroupResults;
import info.movito.themoviedbapi.model.tv.series.ExternalIds;
import info.movito.themoviedbapi.model.tv.series.Images;
import info.movito.themoviedbapi.model.tv.series.ScreenedTheatricallyResults;
import info.movito.themoviedbapi.model.tv.series.Translations;
import info.movito.themoviedbapi.model.tv.series.TvSeriesDb;
import info.movito.themoviedbapi.model.tv.series.TvSeriesListResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbException;
import info.movito.themoviedbapi.tools.appendtoresponse.TvSeriesAppendToResponse;
import info.movito.themoviedbapi.util.JsonUtil;
import java.util.HashMap;

public class TmdbTvSeries
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_TV = "tv";

    TmdbTvSeries(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public TvSeriesDb getDetails(int seriesId, String language, TvSeriesAppendToResponse ... appendToResponse) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId);
        apiUrl.addLanguage(language);
        apiUrl.addAppendToResponses(appendToResponse);
        return this.mapJsonResult(apiUrl, TvSeriesDb.class);
    }

    public AccountStates getAccountStates(int seriesId, String sessionId, String guestSessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "account_states");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, AccountStates.class);
    }

    public AggregateCredits getAggregateCredits(int seriesId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "aggregate_credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, AggregateCredits.class);
    }

    public AlternativeTitleResults getAlternativeTitles(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "alternative_titles");
        return this.mapJsonResult(apiUrl, AlternativeTitleResults.class);
    }

    public ChangeResults getChanges(int seriesId, String startDate, String endDate, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "changes");
        apiUrl.addQueryParam("start_date", startDate);
        apiUrl.addQueryParam("end_date", endDate);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ChangeResults.class);
    }

    public ContentRatingResults getContentRatings(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "content_ratings");
        return this.mapJsonResult(apiUrl, ContentRatingResults.class);
    }

    public Credits getCredits(int seriesId, String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "credits");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, Credits.class);
    }

    public EpisodeGroupResults getEpisodeGroups(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "episode_groups");
        return this.mapJsonResult(apiUrl, EpisodeGroupResults.class);
    }

    public ExternalIds getExternalIds(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "external_ids");
        return this.mapJsonResult(apiUrl, ExternalIds.class);
    }

    public Images getImages(int seriesId, String language, String ... includeImageLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "images");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_image_language", includeImageLanguage);
        return this.mapJsonResult(apiUrl, Images.class);
    }

    public TvKeywords getKeywords(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "keywords");
        return this.mapJsonResult(apiUrl, TvKeywords.class);
    }

    public TvSeriesDb getLatest() throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, "latest");
        return this.mapJsonResult(apiUrl, TvSeriesDb.class);
    }

    public TvSeriesListResultsPage getLists(int seriesId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "lists");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvSeriesListResultsPage.class);
    }

    public TvSeriesResultsPage getRecommendations(int seriesId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "recommendations");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvSeriesResultsPage.class);
    }

    public ReviewResultsPage getReviews(int seriesId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "reviews");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, ReviewResultsPage.class);
    }

    public ScreenedTheatricallyResults getScreenedTheatrically(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "screened_theatrically");
        return this.mapJsonResult(apiUrl, ScreenedTheatricallyResults.class);
    }

    public TvSeriesResultsPage getSimilar(int seriesId, String language, Integer page) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "similar");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvSeriesResultsPage.class);
    }

    public Translations getTranslations(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "translations");
        return this.mapJsonResult(apiUrl, Translations.class);
    }

    public VideoResults getVideos(int seriesId, String language, String ... includeVideoLanguage) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "videos");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParamCommandSeparated("include_image_language", includeVideoLanguage);
        return this.mapJsonResult(apiUrl, VideoResults.class);
    }

    public ProviderResults getWatchProviders(int seriesId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "watch/providers");
        return this.mapJsonResult(apiUrl, ProviderResults.class);
    }

    public ResponseStatus addRating(int seriesId, String guestSessionId, String sessionId, double rating) throws TmdbException {
        if (rating < 0.0 || rating > 10.0) {
            throw new IllegalArgumentException("Rating must be: 0 < rating <= 10");
        }
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "rating");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        HashMap<String, Double> body = new HashMap<String, Double>();
        body.put("value", rating);
        String jsonBody = JsonUtil.toJson(body);
        return this.mapJsonResult(apiUrl, jsonBody, RequestType.POST, ResponseStatus.class);
    }

    public ResponseStatus deleteRating(int seriesId, String guestSessionId, String sessionId) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_TV, seriesId, "rating");
        apiUrl.addQueryParam("session_id", sessionId);
        apiUrl.addQueryParam("guest_session_id", guestSessionId);
        return this.mapJsonResult(apiUrl, null, RequestType.DELETE, ResponseStatus.class);
    }
}

