/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.watchproviders.AvailableRegionResults;
import info.movito.themoviedbapi.model.watchproviders.ProviderResults;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.TmdbException;

public class TmdbWatchProviders
extends AbstractTmdbApi {
    protected static final String TMDB_METHOD_WATCH_PROVIDERS = "watch/providers";

    TmdbWatchProviders(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public AvailableRegionResults getAvailableRegions(String language) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_WATCH_PROVIDERS);
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, AvailableRegionResults.class);
    }

    public ProviderResults getMovieProviders(String language, String watchRegion) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_WATCH_PROVIDERS, "movie");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParam("watch_region", watchRegion);
        return this.mapJsonResult(apiUrl, ProviderResults.class);
    }

    public ProviderResults getTvProviders(String language, String watchRegion) throws TmdbException {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_WATCH_PROVIDERS, "tv");
        apiUrl.addLanguage(language);
        apiUrl.addQueryParam("watch_region", watchRegion);
        return this.mapJsonResult(apiUrl, ProviderResults.class);
    }
}

