/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.tools;

import info.movito.themoviedbapi.tools.appendtoresponse.AppendToResponse;
import info.movito.themoviedbapi.tools.builders.ParamBuilder;
import info.movito.themoviedbapi.tools.sortby.SortBy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ApiUrl {
    public static final String TMDB_API_BASE_URL = "https://api.themoviedb.org/3/";
    private static final String APPEND_TO_RESPONSE = "append_to_response";
    private final String baseUrl;
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    public ApiUrl(Object ... urlElements) {
        StringBuilder baseUrlBuilder = new StringBuilder(TMDB_API_BASE_URL);
        for (int i = 0; i < urlElements.length; ++i) {
            Object object = urlElements[i];
            if (object == null) {
                throw new IllegalArgumentException("url element can not be null");
            }
            baseUrlBuilder.append(object);
            if (i >= urlElements.length - 1) continue;
            baseUrlBuilder.append("/");
        }
        this.baseUrl = baseUrlBuilder.toString();
    }

    public String buildUrl() {
        StringBuilder urlBuilder = new StringBuilder(this.baseUrl);
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            urlBuilder.append(urlBuilder.toString().contains("?") ? "&" : "?").append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return urlBuilder.toString();
    }

    public void addPathParam(String name, Object value) {
        this.addPathParam(name, value.toString());
    }

    public void addPathParam(String name, String value) {
        if (this.params.containsKey(name)) {
            throw new RuntimeException("parameter '" + name + "' already defined");
        }
        if ((name = StringUtils.trimToEmpty((String)name)).isEmpty()) {
            throw new IllegalArgumentException("parameter name can not be empty");
        }
        if ((value = StringUtils.trimToEmpty((String)value)).isEmpty()) {
            throw new IllegalArgumentException("value of parameter '" + name + "' can not be empty");
        }
        this.params.put(name, value);
    }

    public void addPathParams(ParamBuilder paramBuilder) {
        if (paramBuilder == null) {
            return;
        }
        for (Map.Entry<String, String> entry : paramBuilder.getParameterMap().entrySet()) {
            this.addPathParam(entry.getKey(), entry.getValue());
        }
    }

    public void addQueryParam(String key, Object value) {
        if (value != null) {
            this.addPathParam(key, value);
        }
    }

    public void addQueryParamCommandSeparated(String key, String ... values) {
        if (values != null && values.length > 0) {
            this.addPathParam(key, String.join((CharSequence)",", values));
        }
    }

    public void addPage(Integer page) {
        if (page != null && page > 0) {
            this.addPathParam("page", page);
        }
    }

    public void addLanguage(String language) {
        if (StringUtils.isNotBlank((CharSequence)language)) {
            this.addPathParam("language", language);
        }
    }

    public void addAppendToResponses(AppendToResponse ... appendToResponse) {
        if (appendToResponse == null || appendToResponse.length == 0) {
            return;
        }
        String appendToResponseQuery = Arrays.stream(appendToResponse).map(AppendToResponse::getValue).collect(Collectors.joining(","));
        this.addQueryParam(APPEND_TO_RESPONSE, appendToResponseQuery);
    }

    public void addSortBy(SortBy sortBy) {
        if (sortBy != null) {
            this.addQueryParam("sort_by", sortBy.getValue());
        }
    }
}

