/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.tools;

import info.movito.themoviedbapi.model.core.responses.TmdbResponseException;
import info.movito.themoviedbapi.tools.RequestType;
import info.movito.themoviedbapi.tools.TmdbUrlReader;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmdbHttpClient
implements TmdbUrlReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbHttpClient.class);
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private final String apiKey;

    @Override
    public String readUrl(String url, String jsonBody, RequestType requestType) throws TmdbResponseException {
        LOGGER.debug("TMDB API: making request, of type: {}, to: {}", (Object)requestType.toString(), (Object)url);
        URI uri = URI.create(url);
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(uri).header("Authorization", "Bearer " + this.apiKey).header("Accept", "application/json").header("Content-type", "application/json");
        switch (requestType) {
            case GET: {
                httpRequestBuilder.GET();
                break;
            }
            case POST: {
                httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(jsonBody));
                break;
            }
            case DELETE: {
                httpRequestBuilder.DELETE();
                break;
            }
            default: {
                throw new RuntimeException("Invalid request type: " + String.valueOf((Object)requestType));
            }
        }
        try {
            HttpResponse<String> httpResponse = httpClient.send(httpRequestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            String responseBody = httpResponse.body();
            if (responseBody == null) {
                throw new TmdbResponseException("Response body was null: " + String.valueOf(httpResponse));
            }
            return responseBody;
        }
        catch (IOException | InterruptedException exception) {
            throw new TmdbResponseException(exception);
        }
    }

    @Generated
    public TmdbHttpClient(String apiKey) {
        this.apiKey = apiKey;
    }
}

