/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.tools.builders.discover;

import info.movito.themoviedbapi.tools.builders.discover.DiscoverParamBuilder;
import info.movito.themoviedbapi.tools.sortby.DiscoverMovieSortBy;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DiscoverMovieParamBuilder
extends DiscoverParamBuilder<DiscoverMovieParamBuilder> {
    private static final String PARAM_CERTIFICATION = "certification";
    private static final String PARAM_CERTIFICATION_GTE = "certification.gte";
    private static final String PARAM_CERTIFICATION_LTE = "certification.lte";
    private static final String PARAM_CERTIFICATION_COUNTRY = "certification_country";
    private static final String PARAM_INCLUDE_VIDEO = "include_video";
    private static final String PARAM_PRIMARY_RELEASE_YEAR = "primary_release_year";
    private static final String PARAM_PRIMARY_RELEASE_DATE_GTE = "primary_release_date.gte";
    private static final String PARAM_PRIMARY_RELEASE_DATE_LTE = "primary_release_date.lte";
    private static final String PARAM_REGION = "region";
    private static final String PARAM_RELEASE_DATE_GTE = "release_date.gte";
    private static final String PARAM_RELEASE_DATE_LTE = "release_date.lte";
    private static final String PARAM_WITH_CAST = "with_cast";
    private static final String PARAM_WITH_CREW = "with_crew";
    private static final String PARAM_WITH_PEOPLE = "with_people";
    private static final String PARAM_WITH_RELEASE_TYPE = "with_release_type";
    private static final String PARAM_YEAR = "year";

    @Override
    protected DiscoverMovieParamBuilder me() {
        return this;
    }

    public DiscoverMovieParamBuilder certification(String certification) {
        if (StringUtils.isBlank((CharSequence)certification)) {
            throw new IllegalArgumentException("certification can not be blank");
        }
        this.getParams().put(PARAM_CERTIFICATION, certification);
        return this.me();
    }

    public DiscoverMovieParamBuilder certificationGte(String certificationGte) {
        if (StringUtils.isBlank((CharSequence)certificationGte)) {
            throw new IllegalArgumentException("certificationGte can not be blank");
        }
        this.getParams().put(PARAM_CERTIFICATION_GTE, certificationGte);
        return this.me();
    }

    public DiscoverMovieParamBuilder certificationLte(String certificationLte) {
        if (StringUtils.isBlank((CharSequence)certificationLte)) {
            throw new IllegalArgumentException("certificationLte can not be blank");
        }
        this.getParams().put(PARAM_CERTIFICATION_LTE, certificationLte);
        return this.me();
    }

    public DiscoverMovieParamBuilder certificationCountry(String certificationCountry) {
        if (StringUtils.isBlank((CharSequence)certificationCountry)) {
            throw new IllegalArgumentException("certificationCountry can not be blank");
        }
        this.getParams().put(PARAM_CERTIFICATION_COUNTRY, certificationCountry);
        return this.me();
    }

    public DiscoverMovieParamBuilder includeVideo(boolean includeVideo) {
        this.getParams().put(PARAM_INCLUDE_VIDEO, String.valueOf(includeVideo));
        return this.me();
    }

    public DiscoverMovieParamBuilder primaryReleaseYear(int primaryReleaseYear) {
        this.getParams().put(PARAM_PRIMARY_RELEASE_YEAR, String.valueOf(primaryReleaseYear));
        return this.me();
    }

    public DiscoverMovieParamBuilder primaryReleaseDateGte(String primaryReleaseDateGte) {
        if (StringUtils.isBlank((CharSequence)primaryReleaseDateGte)) {
            throw new IllegalArgumentException("primaryReleaseDateGte can not be blank");
        }
        this.getParams().put(PARAM_PRIMARY_RELEASE_DATE_GTE, primaryReleaseDateGte);
        return this.me();
    }

    public DiscoverMovieParamBuilder primaryReleaseDateLte(String primaryReleaseDateLte) {
        if (StringUtils.isBlank((CharSequence)primaryReleaseDateLte)) {
            throw new IllegalArgumentException("primaryReleaseDateLte can not be blank");
        }
        this.getParams().put(PARAM_PRIMARY_RELEASE_DATE_LTE, primaryReleaseDateLte);
        return this.me();
    }

    public DiscoverMovieParamBuilder region(String region) {
        if (StringUtils.isBlank((CharSequence)region)) {
            throw new IllegalArgumentException("region can not be blank");
        }
        this.getParams().put(PARAM_REGION, region);
        return this.me();
    }

    public DiscoverMovieParamBuilder releaseDateGte(String releaseDateGte) {
        if (StringUtils.isBlank((CharSequence)releaseDateGte)) {
            throw new IllegalArgumentException("releaseDateGte can not be blank");
        }
        this.getParams().put(PARAM_RELEASE_DATE_GTE, releaseDateGte);
        return this.me();
    }

    public DiscoverMovieParamBuilder releaseDateLte(String releaseDateLte) {
        if (StringUtils.isBlank((CharSequence)releaseDateLte)) {
            throw new IllegalArgumentException("releaseDateLte can not be blank");
        }
        this.getParams().put(PARAM_RELEASE_DATE_LTE, releaseDateLte);
        return this.me();
    }

    public DiscoverMovieParamBuilder sortBy(DiscoverMovieSortBy sortBy) {
        this.getParams().put("sort_by", sortBy.getValue());
        return this.me();
    }

    public DiscoverMovieParamBuilder withCast(List<Integer> castIds, boolean orQuery) {
        if (castIds == null || castIds.isEmpty()) {
            throw new IllegalArgumentException("Cast must be set");
        }
        String query = castIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.getParams().put(PARAM_WITH_CAST, query);
        return this.me();
    }

    public DiscoverMovieParamBuilder withCrew(List<Integer> crewIds, boolean orQuery) {
        if (crewIds == null || crewIds.isEmpty()) {
            throw new IllegalArgumentException("crewIds must be set");
        }
        String query = crewIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.getParams().put(PARAM_WITH_CREW, query);
        return this.me();
    }

    public DiscoverMovieParamBuilder withPeople(List<Integer> peopleIds, boolean orQuery) {
        if (peopleIds == null || peopleIds.isEmpty()) {
            throw new IllegalArgumentException("peopleIds must be set");
        }
        String query = peopleIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.getParams().put(PARAM_WITH_PEOPLE, query);
        return this.me();
    }

    public DiscoverMovieParamBuilder withReleaseType(List<Integer> releaseTypeIds, boolean orQuery) {
        if (releaseTypeIds == null || releaseTypeIds.isEmpty()) {
            throw new IllegalArgumentException("releaseTypeIds must be set");
        }
        String query = releaseTypeIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.getParams().put(PARAM_WITH_RELEASE_TYPE, query);
        return this.me();
    }

    public DiscoverMovieParamBuilder year(int year) {
        this.getParams().put(PARAM_YEAR, String.valueOf(year));
        return this.me();
    }
}

