/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.tools.builders.discover;

import info.movito.themoviedbapi.tools.builders.ParamBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class DiscoverParamBuilder<T extends DiscoverParamBuilder<T>>
implements ParamBuilder {
    protected static final String PARAM_SORT_BY = "sort_by";
    private static final String PARAM_VOTE_AVERAGE_GTE = "vote_average.gte";
    private static final String PARAM_VOTE_AVERAGE_LTE = "vote_average.lte";
    private static final String PARAM_VOTE_COUNT_GTE = "vote_count.gte";
    private static final String PARAM_VOTE_COUNT_LTE = "vote_count.lte";
    private static final String PARAM_WATCH_MONETIZATION_TYPES = "with_watch_monetization_types";
    private static final String PARAM_WATCH_REGION = "watch_region";
    private static final String PARAM_WITHOUT_COMPANIES = "without_companies";
    private static final String PARAM_WITHOUT_GENRES = "without_genres";
    private static final String PARAM_WITHOUT_KEYWORDS = "without_keywords";
    private static final String PARAM_WITHOUT_WATCH_PROVIDERS = "without_watch_providers";
    private static final String PARAM_WITH_COMPANIES = "with_companies";
    private static final String PARAM_WITH_GENRES = "with_genres";
    private static final String PARAM_WITH_KEYWORDS = "with_keywords";
    private static final String PARAM_WITH_ORIGIN_COUNTRY = "with_origin_country";
    private static final String PARAM_WITH_ORIGINAL_LANGUAGE = "with_original_language";
    private static final String PARAM_WITH_RUNTIME_GTE = "with_runtime.gte";
    private static final String PARAM_WITH_RUNTIME_LTE = "with_runtime.lte";
    private static final String PARAM_WITH_WATCH_PROVIDERS = "with_watch_providers";
    private final Map<String, String> params = new HashMap<String, String>();

    protected abstract T me();

    @Override
    public Map<String, String> getParameterMap() {
        return this.params;
    }

    public T page(int page) {
        if (page <= 0) {
            throw new IllegalArgumentException("Page must be greater than 0");
        }
        this.params.put("page", String.valueOf(page));
        return this.me();
    }

    public T language(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            throw new IllegalArgumentException("Language must be set");
        }
        this.params.put("language", language);
        return this.me();
    }

    public T includeAdult(boolean includeAdult) {
        this.params.put("include_adult", String.valueOf(includeAdult));
        return this.me();
    }

    public T withOriginalLanguage(String withOriginalLanguage) {
        if (StringUtils.isBlank((CharSequence)withOriginalLanguage)) {
            throw new IllegalArgumentException("Original language must be set");
        }
        this.params.put(PARAM_WITH_ORIGINAL_LANGUAGE, withOriginalLanguage);
        return this.me();
    }

    public T voteAverageGte(double voteAverageGte) {
        if (voteAverageGte < 0.0) {
            throw new IllegalArgumentException("Vote average must be >= 0");
        }
        this.params.put(PARAM_VOTE_AVERAGE_GTE, String.valueOf(voteAverageGte));
        return this.me();
    }

    public T voteAverageLte(double voteAverageLte) {
        if (voteAverageLte < 0.0) {
            throw new IllegalArgumentException("Vote average must be >= 0");
        }
        this.params.put(PARAM_VOTE_AVERAGE_LTE, String.valueOf(voteAverageLte));
        return this.me();
    }

    public T voteCountGte(double voteCountGte) {
        if (voteCountGte < 0.0) {
            throw new IllegalArgumentException("Vote count must be >= 0");
        }
        this.params.put(PARAM_VOTE_COUNT_GTE, String.valueOf(voteCountGte));
        return this.me();
    }

    public T voteCountLte(double voteCountLte) {
        if (voteCountLte > 0.0) {
            throw new IllegalArgumentException("Vote count must be >= 0");
        }
        this.params.put(PARAM_VOTE_COUNT_LTE, String.valueOf(voteCountLte));
        return this.me();
    }

    public T withWatchMonetizationTypes(List<String> withWatchMonetizationTypes, boolean orQuery) {
        if (withWatchMonetizationTypes == null || withWatchMonetizationTypes.isEmpty()) {
            throw new IllegalArgumentException("Watch monetization types must be set");
        }
        String query = String.join((CharSequence)(orQuery ? "|" : ","), withWatchMonetizationTypes);
        this.params.put(PARAM_WATCH_MONETIZATION_TYPES, query);
        return this.me();
    }

    public T watchRegion(String watchRegion) {
        if (StringUtils.isBlank((CharSequence)watchRegion)) {
            throw new IllegalArgumentException("Watch region must be set");
        }
        this.params.put(PARAM_WATCH_REGION, watchRegion);
        return this.me();
    }

    public T withoutCompanies(List<Integer> companies) {
        if (companies == null || companies.isEmpty()) {
            throw new IllegalArgumentException("Without companies must be set");
        }
        String query = companies.stream().map(Object::toString).collect(Collectors.joining(","));
        this.params.put(PARAM_WITHOUT_COMPANIES, query);
        return this.me();
    }

    public T withoutGenres(List<Integer> genres) {
        if (genres == null || genres.isEmpty()) {
            throw new IllegalArgumentException("Without genres must be set");
        }
        String query = genres.stream().map(Object::toString).collect(Collectors.joining(","));
        this.params.put(PARAM_WITHOUT_GENRES, query);
        return this.me();
    }

    public T withoutKeywords(List<String> keywords) {
        if (keywords == null || keywords.isEmpty()) {
            throw new IllegalArgumentException("Without keywords must be set");
        }
        String query = String.join((CharSequence)",", keywords);
        this.params.put(PARAM_WITHOUT_KEYWORDS, query);
        return this.me();
    }

    public T withoutWatchProviders(List<Integer> watchProviders) {
        if (watchProviders == null || watchProviders.isEmpty()) {
            throw new IllegalArgumentException("Without watch providers must be set");
        }
        String query = watchProviders.stream().map(Object::toString).collect(Collectors.joining(","));
        this.params.put(PARAM_WITHOUT_WATCH_PROVIDERS, query);
        return this.me();
    }

    public T withCompanies(List<Integer> companyIds, boolean orQuery) {
        if (companyIds == null || companyIds.isEmpty()) {
            throw new IllegalArgumentException("With companies must be set");
        }
        String query = companyIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.params.put(PARAM_WITH_COMPANIES, query);
        return this.me();
    }

    public T withGenres(List<Integer> genreIds, boolean orQuery) {
        if (genreIds == null || genreIds.isEmpty()) {
            throw new IllegalArgumentException("With genres must be set");
        }
        String query = genreIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.params.put(PARAM_WITH_GENRES, query);
        return this.me();
    }

    public T withKeywords(List<Integer> keywordIds, boolean orQuery) {
        if (keywordIds == null || keywordIds.isEmpty()) {
            throw new IllegalArgumentException("With keywords must be set");
        }
        String query = keywordIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.params.put(PARAM_WITH_KEYWORDS, query);
        return this.me();
    }

    public T withOriginCountry(String originCountry) {
        if (StringUtils.isBlank((CharSequence)originCountry)) {
            throw new IllegalArgumentException("Origin country must be set");
        }
        this.params.put(PARAM_WITH_ORIGIN_COUNTRY, originCountry);
        return this.me();
    }

    public T withRuntimeGte(int runtimeGte) {
        if (runtimeGte < 0) {
            throw new IllegalArgumentException("Runtime must be >= 0");
        }
        this.params.put(PARAM_WITH_RUNTIME_GTE, String.valueOf(runtimeGte));
        return this.me();
    }

    public T withRuntimeLte(int runtimeLte) {
        if (runtimeLte < 0) {
            throw new IllegalArgumentException("Runtime must be >= 0");
        }
        this.params.put(PARAM_WITH_RUNTIME_LTE, String.valueOf(runtimeLte));
        return this.me();
    }

    public T withWatchProviders(List<Integer> watchProviderIds, boolean orQuery) {
        if (watchProviderIds == null || watchProviderIds.isEmpty()) {
            throw new IllegalArgumentException("With watch providers must be set");
        }
        String query = watchProviderIds.stream().map(Object::toString).collect(Collectors.joining(orQuery ? "|" : ","));
        this.params.put(PARAM_WITH_WATCH_PROVIDERS, query);
        return this.me();
    }

    @Generated
    protected Map<String, String> getParams() {
        return this.params;
    }
}

