/*
 * Decompiled with CFR 0.152.
 */
package uk.co.datumedge.hamcrest.json;

import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.skyscreamer.jsonassert.FieldComparisonFailure;
import org.skyscreamer.jsonassert.JSONCompareResult;
import uk.co.datumedge.hamcrest.json.JSONComparisonResult;

final class JSONAssertComparisonResult {
    private JSONAssertComparisonResult() {
    }

    static JSONComparisonResult resultOf(JSONCompareResult result) {
        if (result.failed()) {
            return JSONAssertComparisonResult.diagnose(result);
        }
        return JSONComparisonResult.comparisonPassed();
    }

    private static JSONComparisonResult diagnose(final JSONCompareResult result) {
        return new JSONComparisonResult(new SelfDescribing(){

            public void describeTo(Description description) {
                boolean first = true;
                for (FieldComparisonFailure failure : result.getFieldFailures()) {
                    if (!first) {
                        description.appendText(" and ");
                    }
                    description.appendText("field ").appendText(failure.getField()).appendText(" was ").appendValue(failure.getActual()).appendText(" instead of ").appendValue(failure.getExpected());
                    first = false;
                }
                if (result.getFieldFailures().isEmpty()) {
                    description.appendText(result.getMessage());
                }
            }
        });
    }
}

