/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deliverymind.wiremock.maven.plugin;

import com.github.tomakehurst.wiremock.standalone.WireMockServerRunner;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import uk.co.deliverymind.wiremock.maven.plugin.ConfigurationMojo;

@Mojo(name="run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WireMockMojo
extends ConfigurationMojo {
    public void execute() throws MojoExecutionException {
        this.addRuntimeDependenciesToClasspath();
        String wireMockParams = Arrays.toString(this.getAllParams()).replaceAll("[\\[\\]]", "").replaceAll(", ", " ");
        this.getLog().info((CharSequence)("Starting WireMock with following params: " + wireMockParams));
        WireMockServerRunner.main((String[])this.getAllParams());
        if (this.shouldKeepRunning()) {
            this.getLog().info((CharSequence)"WireMock will keep running until interrupted manually...");
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    this.getLog().error((CharSequence)e.getMessage());
                    continue;
                }
                break;
            }
        }
    }

    private void addRuntimeDependenciesToClasspath() throws MojoExecutionException {
        ClassRealm realm = this.getDescriptor().getClassRealm();
        for (String element : this.getClasspathElements()) {
            this.getLog().info((CharSequence)String.format("Adding %s to wiremock-maven-plugin classpath", element));
            File elementFile = new File(element);
            try {
                realm.addURL(elementFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Malformed classpath URL", (Exception)e);
            }
        }
    }
}

