/*
 * Decompiled with CFR 0.152.
 */
package uk.co.lucasweb.aws.v4.signer.credentials;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import uk.co.lucasweb.aws.v4.signer.SigningException;
import uk.co.lucasweb.aws.v4.signer.credentials.AwsCredentials;
import uk.co.lucasweb.aws.v4.signer.credentials.AwsCredentialsProvider;
import uk.co.lucasweb.aws.v4.signer.functional.Streams;

public class AwsCredentialsProviderChain {
    static final String ACCESS_KEY_ENV_VAR = "AWS_ACCESS_KEY";
    static final String SECRET_KEY_ENV_VAR = "AWS_SECRET_KEY";
    static final String ACCESS_KEY_SYSTEM_PROPERTY = "aws.accessKeyId";
    static final String SECRET_KEY_SYSTEM_PROPERTY = "aws.secretKey";
    EnvironmentVarResolver environmentVarResolver;
    private final List<AwsCredentialsProvider> providers;

    public AwsCredentialsProviderChain() {
        this(new EnvironmentVarResolver());
    }

    public AwsCredentialsProviderChain(EnvironmentVarResolver environmentVarResolver) {
        this.environmentVarResolver = environmentVarResolver;
        this.providers = new ArrayList<AwsCredentialsProvider>();
        this.providers.add(this.systemPropertiesProvider());
        this.providers.add(this.environmentProvider());
    }

    public AwsCredentials getCredentials() {
        return (AwsCredentials)this.providers.stream().flatMap(p -> Streams.streamopt(p.getCredentials())).findFirst().orElseThrow(() -> new SigningException("no AWS credentials were provided"));
    }

    AwsCredentialsProvider environmentProvider() {
        return () -> this.getAwsCredentials(this.environmentVarResolver.getenv(ACCESS_KEY_ENV_VAR), this.environmentVarResolver.getenv(SECRET_KEY_ENV_VAR));
    }

    AwsCredentialsProvider systemPropertiesProvider() {
        return () -> this.getAwsCredentials(System.getProperty(ACCESS_KEY_SYSTEM_PROPERTY), System.getProperty(SECRET_KEY_SYSTEM_PROPERTY));
    }

    private Optional<AwsCredentials> getAwsCredentials(String accessKey, String secretKey) {
        Optional<String> optionalAccessKey = Optional.ofNullable(accessKey);
        Optional<String> optionalSecretKey = Optional.ofNullable(secretKey);
        if (optionalAccessKey.isPresent() && optionalSecretKey.isPresent()) {
            return Optional.of(new AwsCredentials(optionalAccessKey.get(), optionalSecretKey.get()));
        }
        return Optional.empty();
    }

    static class EnvironmentVarResolver {
        EnvironmentVarResolver() {
        }

        String getenv(String name) {
            return System.getenv(name);
        }
    }
}

