/*
 * Decompiled with CFR 0.152.
 */
package uk.co.paulbenn.gzip;

import java.util.Arrays;
import uk.co.paulbenn.gzip.GzipHeader;
import uk.co.paulbenn.gzip.GzipTrailer;

public class GzipEntry {
    private final GzipHeader header;
    private final byte[] bytes;
    private final GzipTrailer trailer;

    public GzipEntry(byte[] deflated) {
        GzipEntry.checkNotNull(deflated);
        try {
            this.header = new GzipHeader(GzipEntry.getHeaderBytes(deflated));
            this.bytes = deflated;
            this.trailer = new GzipTrailer(GzipEntry.getTrailerBytes(deflated));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("deflated byte array must be of length %d or greater", 18), e);
        }
    }

    private static void checkNotNull(byte[] deflated) {
        if (deflated == null) {
            throw new NullPointerException("cannot inspect null byte array");
        }
    }

    private static byte[] getHeaderBytes(byte[] deflated) {
        return Arrays.copyOfRange(deflated, 0, 10);
    }

    private static byte[] getTrailerBytes(byte[] deflated) {
        return Arrays.copyOfRange(deflated, deflated.length - 8, deflated.length);
    }

    public GzipHeader getHeader() {
        return this.header;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public GzipTrailer getTrailer() {
        return this.trailer;
    }

    public String toString() {
        return "GzipEntry (" + this.bytes.length + " bytes)";
    }
}

