/*
 * Decompiled with CFR 0.152.
 */
package uk.co.paulbenn.gzip;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import uk.co.paulbenn.gzip.CompressionMethod;
import uk.co.paulbenn.gzip.Gzip;
import uk.co.paulbenn.gzip.OperatingSystem;

public class GzipHeader {
    public static final int MIN_LENGTH = 10;
    private static final byte ID1 = Gzip.MAGIC[0];
    private static final byte ID2 = Gzip.MAGIC[1];
    private static final byte[] NO_TIMESTAMP_AVAILABLE = new byte[]{0, 0, 0, 0};
    private final byte CM;
    private final CompressionMethod compressionMethod;
    private final byte FLG;
    private final Flags flags;
    private final byte[] MTIME;
    private final Instant modificationTime;
    private final byte XFL;
    private final byte OS;
    private final OperatingSystem operatingSystem;

    public GzipHeader() {
        this.CM = (byte)8;
        this.compressionMethod = CompressionMethod.DEFLATE;
        this.FLG = 0;
        this.flags = Flags.NO_FLAGS;
        this.MTIME = NO_TIMESTAMP_AVAILABLE;
        this.modificationTime = null;
        this.XFL = 0;
        this.OS = 0;
        this.operatingSystem = OperatingSystem.UNKNOWN;
    }

    public GzipHeader(byte[] gzipHeader) {
        this.checkHeaderValidity(gzipHeader);
        this.CM = gzipHeader[2];
        this.compressionMethod = CompressionMethod.of(this.CM);
        this.FLG = gzipHeader[3];
        this.flags = Flags.of(this.FLG);
        if (Arrays.equals(NO_TIMESTAMP_AVAILABLE, 0, 4, gzipHeader, 4, 8)) {
            this.MTIME = NO_TIMESTAMP_AVAILABLE;
            this.modificationTime = null;
        } else {
            this.MTIME = Arrays.copyOfRange(gzipHeader, 4, 8);
            this.modificationTime = Instant.ofEpochSecond(ByteBuffer.wrap(this.MTIME).getInt());
        }
        this.XFL = gzipHeader[8];
        this.OS = gzipHeader[9];
        this.operatingSystem = OperatingSystem.of(this.OS);
    }

    public int getMinLength() {
        return 10;
    }

    public byte getID1() {
        return ID1;
    }

    public byte getID2() {
        return ID2;
    }

    public byte[] getMagic() {
        return Gzip.MAGIC;
    }

    public byte getCM() {
        return this.CM;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public byte getFLG() {
        return this.FLG;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public byte[] getMTIME() {
        return this.MTIME;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public byte getXFL() {
        return this.XFL;
    }

    public byte getOS() {
        return this.OS;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    private void checkHeaderValidity(byte[] gzipHeader) {
        if (gzipHeader == null) {
            throw new NullPointerException("cannot create gzip header from null byte array");
        }
        if (gzipHeader.length != 10) {
            throw new IllegalArgumentException("gzip header must be exactly 10 bytes");
        }
        if (gzipHeader[0] != Gzip.MAGIC[0] || gzipHeader[1] != Gzip.MAGIC[1]) {
            throw new IllegalArgumentException("gzip header must start with magic number " + Integer.toHexString(ByteBuffer.wrap(Gzip.MAGIC).getInt()));
        }
    }

    public String toString() {
        return "GzipHeader (flags = " + this.flags + ")";
    }

    public static class Flags {
        private static final Flags NO_FLAGS = Flags.of((byte)0);
        private static final byte FTEXT = -128;
        private static final byte FHCRC = 64;
        private static final byte FEXTRA = 32;
        private static final byte FNAME = 16;
        private static final byte FCOMMENT = 8;
        private byte value;

        private Flags() {
        }

        public static Flags of(byte value) {
            Flags flags = new Flags();
            flags.value = value;
            return flags;
        }

        public boolean isProbableAscii() {
            return (this.value & 0xFFFFFF80) != 0;
        }

        public boolean isCrc16() {
            return (this.value & 0x40) != 0;
        }

        public boolean hasOptionalFields() {
            return (this.value & 0x20) != 0;
        }

        public boolean hasFileName() {
            return (this.value & 0x10) != 0;
        }

        public boolean hasComment() {
            return (this.value & 8) != 0;
        }

        public byte getValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toBinaryString(this.value);
        }
    }
}

