/*
 * Decompiled with CFR 0.152.
 */
package uk.co.paulbenn.gzip;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class GzipTrailer {
    public static final int LENGTH = 8;
    private final byte[] CRC32;
    private final int crc32;
    private final byte[] ISIZE;
    private final int uncompressedSize;

    public GzipTrailer(byte[] gzipTrailer) {
        this.checkTrailerValidity(gzipTrailer);
        this.CRC32 = this.reverseEndianness(Arrays.copyOfRange(gzipTrailer, 0, 4));
        this.crc32 = ByteBuffer.wrap(this.CRC32).getInt();
        this.ISIZE = this.reverseEndianness(Arrays.copyOfRange(gzipTrailer, 4, 8));
        this.uncompressedSize = ByteBuffer.wrap(this.ISIZE).getInt();
    }

    public int getLength() {
        return 8;
    }

    public byte[] getCRC32() {
        return this.CRC32;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public byte[] getISIZE() {
        return this.ISIZE;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public String toString() {
        return "GzipTrailer (uncompressedSize = " + this.uncompressedSize + " bytes)";
    }

    private void checkTrailerValidity(byte[] gzipTrailer) {
        if (gzipTrailer == null) {
            throw new NullPointerException("cannot create gzip trailer from null byte array");
        }
        if (gzipTrailer.length != 8) {
            throw new IllegalArgumentException("gzip trailer must be exactly 8 bytes");
        }
    }

    private byte[] reverseEndianness(byte[] source) {
        for (int i = 0; i < source.length / 2; ++i) {
            byte tmp = source[i];
            source[i] = source[source.length - i - 1];
            source[source.length - i - 1] = tmp;
        }
        return source;
    }
}

