/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import sun.misc.Unsafe;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.MutableDirectBuffer;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;

public class UnsafeBuffer
implements AtomicBuffer {
    public static final String DISABLE_BOUNDS_CHECKS_PROP_NAME = "agrona.disable.bounds.checks";
    public static final boolean SHOULD_BOUNDS_CHECK = !Boolean.getBoolean("agrona.disable.bounds.checks");
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    private static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private byte[] byteArray;
    private ByteBuffer byteBuffer;
    private long addressOffset;
    private int capacity;

    public UnsafeBuffer(byte[] buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(byte[] buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(ByteBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(ByteBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(DirectBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(long address, int length) {
        this.wrap(address, length);
    }

    @Override
    public void wrap(byte[] buffer) {
        this.addressOffset = ARRAY_BASE_OFFSET;
        this.capacity = buffer.length;
        this.byteArray = buffer;
        this.byteBuffer = null;
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int bufferLength = buffer.length;
            if (offset != 0 && (offset < 0 || offset > bufferLength - 1)) {
                throw new IllegalArgumentException("offset=" + offset + " not valid for buffer.length=" + bufferLength);
            }
            if (length < 0 || length > bufferLength - offset) {
                throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for buffer.length=" + bufferLength);
            }
        }
        this.addressOffset = ARRAY_BASE_OFFSET + (long)offset;
        this.capacity = length;
        this.byteArray = buffer;
        this.byteBuffer = null;
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        if (buffer.hasArray()) {
            this.byteArray = buffer.array();
            this.addressOffset = ARRAY_BASE_OFFSET + (long)buffer.arrayOffset();
        } else {
            this.byteArray = null;
            this.addressOffset = ((sun.nio.ch.DirectBuffer)((Object)buffer)).address();
        }
        this.capacity = buffer.capacity();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int bufferCapacity = buffer.capacity();
            if (offset != 0 && (offset < 0 || offset > bufferCapacity - 1)) {
                throw new IllegalArgumentException("offset=" + offset + " not valid for buffer.capacity()=" + bufferCapacity);
            }
            if (length < 0 || length > bufferCapacity - offset) {
                throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for buffer.capacity()=" + bufferCapacity);
            }
        }
        this.byteBuffer = buffer;
        if (buffer.hasArray()) {
            this.byteArray = buffer.array();
            this.addressOffset = ARRAY_BASE_OFFSET + (long)buffer.arrayOffset() + (long)offset;
        } else {
            this.byteArray = null;
            this.addressOffset = ((sun.nio.ch.DirectBuffer)((Object)buffer)).address() + (long)offset;
        }
        this.capacity = length;
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        this.addressOffset = buffer.addressOffset();
        this.capacity = buffer.capacity();
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int bufferCapacity = buffer.capacity();
            if (offset != 0 && (offset < 0 || offset > bufferCapacity - 1)) {
                throw new IllegalArgumentException("offset=" + offset + " not valid for buffer.capacity()=" + bufferCapacity);
            }
            if (length < 0 || length > bufferCapacity - offset) {
                throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for buffer.capacity()=" + bufferCapacity);
            }
        }
        this.addressOffset = buffer.addressOffset() + (long)offset;
        this.capacity = length;
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
    }

    @Override
    public void wrap(long address, int length) {
        this.addressOffset = address;
        this.capacity = length;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    @Override
    public long addressOffset() {
        return this.addressOffset;
    }

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        this.boundsCheck(index, length);
        UNSAFE.setMemory(this.byteArray, this.addressOffset + (long)index, length, value);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void checkLimit(int limit) {
        if (limit > this.capacity) {
            String msg = String.format("limit=%d is beyond capacity=%d", limit, this.capacity);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        long bits = UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        long bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        this.boundsCheck(index, 8);
        return UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        this.boundsCheck(index, 8);
        UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getLongVolatile(int index) {
        this.boundsCheck(index, 8);
        return UNSAFE.getLongVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLongVolatile(int index, long value) {
        this.boundsCheck(index, 8);
        UNSAFE.putLongVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putLongOrdered(int index, long value) {
        this.boundsCheck(index, 8);
        UNSAFE.putOrderedLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void addLongOrdered(int index, long increment) {
        this.boundsCheck(index, 8);
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        long value = UNSAFE.getLong(byteArray, offset);
        UNSAFE.putOrderedLong(byteArray, offset, value + increment);
    }

    @Override
    public boolean compareAndSetLong(int index, long expectedValue, long updateValue) {
        this.boundsCheck(index, 8);
        return UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public long getAndSetLong(int index, long value) {
        this.boundsCheck(index, 8);
        return UNSAFE.getAndSetLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getAndAddLong(int index, long delta) {
        this.boundsCheck(index, 8);
        return UNSAFE.getAndAddLong(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        int bits = UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        int bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        this.boundsCheck(index, 4);
        return UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putInt(int index, int value) {
        this.boundsCheck(index, 4);
        UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getIntVolatile(int index) {
        this.boundsCheck(index, 4);
        return UNSAFE.getIntVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putIntVolatile(int index, int value) {
        this.boundsCheck(index, 4);
        UNSAFE.putIntVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putIntOrdered(int index, int value) {
        this.boundsCheck(index, 4);
        UNSAFE.putOrderedInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void addIntOrdered(int index, int increment) {
        this.boundsCheck(index, 4);
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        int value = UNSAFE.getInt(byteArray, offset);
        UNSAFE.putOrderedInt(byteArray, offset, value + increment);
    }

    @Override
    public boolean compareAndSetInt(int index, int expectedValue, int updateValue) {
        this.boundsCheck(index, 4);
        return UNSAFE.compareAndSwapInt(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public int getAndSetInt(int index, int value) {
        this.boundsCheck(index, 4);
        return UNSAFE.getAndSetInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getAndAddInt(int index, int delta) {
        this.boundsCheck(index, 4);
        return UNSAFE.getAndAddInt(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        this.boundsCheck(index, 8);
        return UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        this.boundsCheck(index, 8);
        UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        this.boundsCheck(index, 4);
        return UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        this.boundsCheck(index, 4);
        UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 2);
        short bits = UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.boundsCheck(index, 2);
        short bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        this.boundsCheck(index, 2);
        return UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        this.boundsCheck(index, 2);
        UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShortVolatile(int index) {
        this.boundsCheck(index, 2);
        return UNSAFE.getShortVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShortVolatile(int index, short value) {
        this.boundsCheck(index, 2);
        UNSAFE.putShortVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        this.boundsCheck(index, 1);
        return UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByte(int index, byte value) {
        this.boundsCheck(index, 1);
        UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        this.boundsCheck(index, length);
        UnsafeBuffer.boundsCheck(dst, offset, length);
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, ARRAY_BASE_OFFSET + (long)offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        this.boundsCheck(index, length);
        int dstOffset = dstBuffer.position();
        UnsafeBuffer.boundsCheck(dstBuffer, dstOffset, length);
        if (dstBuffer.hasArray()) {
            dstByteArray = dstBuffer.array();
            dstBaseOffset = ARRAY_BASE_OFFSET + (long)dstBuffer.arrayOffset();
        } else {
            dstByteArray = null;
            dstBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)dstBuffer)).address();
        }
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
        dstBuffer.position(dstBuffer.position() + length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        this.putBytes(index, src, 0, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        this.boundsCheck(index, length);
        UnsafeBuffer.boundsCheck(src, offset, length);
        UNSAFE.copyMemory(src, ARRAY_BASE_OFFSET + (long)offset, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        this.boundsCheck(index, length);
        int srcIndex = srcBuffer.position();
        UnsafeBuffer.boundsCheck(srcBuffer, srcIndex, length);
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        this.boundsCheck(index, length);
        UnsafeBuffer.boundsCheck(srcBuffer, srcIndex, length);
        if (srcBuffer.hasArray()) {
            srcByteArray = srcBuffer.array();
            srcBaseOffset = ARRAY_BASE_OFFSET + (long)srcBuffer.arrayOffset();
        } else {
            srcByteArray = null;
            srcBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)srcBuffer)).address();
        }
        UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.boundsCheck(index, length);
        srcBuffer.boundsCheck(srcIndex, length);
        UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public String getStringUtf8(int offset, ByteOrder byteOrder) {
        int length = this.getInt(offset, byteOrder);
        return this.getStringUtf8(offset, length);
    }

    @Override
    public String getStringUtf8(int offset, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(offset + 4, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int offset, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(offset, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int offset, String value, ByteOrder byteOrder, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(offset, bytes.length, byteOrder);
        this.putBytes(offset + 4, bytes);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int offset, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(offset, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int offset, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : NULL_BYTES;
        this.putBytes(offset, bytes);
        return bytes.length;
    }

    @Override
    public void boundsCheck(int index, int length) {
        if (SHOULD_BOUNDS_CHECK && (index < 0 || length < 0 || index + length > this.capacity)) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, this.capacity));
        }
    }

    private static void boundsCheck(byte[] buffer, int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int capacity = buffer.length;
            if (index < 0 || length < 0 || index + length > capacity) {
                throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, capacity));
            }
        }
    }

    private static void boundsCheck(ByteBuffer buffer, int index, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int capacity = buffer.capacity();
            if (index < 0 || length < 0 || index + length > capacity) {
                throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, capacity));
            }
        }
    }
}

