/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent.ringbuffer;

import uk.co.real_logic.agrona.BitUtil;

public class RingBufferDescriptor {
    public static final int TAIL_COUNTER_OFFSET;
    public static final int HEAD_COUNTER_OFFSET;
    public static final int CORRELATION_COUNTER_OFFSET;
    public static final int CONSUMER_HEARTBEAT_OFFSET;
    public static final int TRAILER_LENGTH;

    public static void checkCapacity(int capacity) {
        if (!BitUtil.isPowerOfTwo(capacity)) {
            String msg = "Capacity must be a positive power of 2 + TRAILER_LENGTH: capacity=" + capacity;
            throw new IllegalStateException(msg);
        }
    }

    static {
        int offset;
        TAIL_COUNTER_OFFSET = offset = 0;
        HEAD_COUNTER_OFFSET = offset += 64;
        CORRELATION_COUNTER_OFFSET = offset += 64;
        CONSUMER_HEARTBEAT_OFFSET = offset += 64;
        TRAILER_LENGTH = offset += 64;
    }
}

