/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.real_logic.aeron.CncFileDescriptor;
import uk.co.real_logic.aeron.CommonContext;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.IoUtil;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.CountersReader;
import uk.co.real_logic.agrona.concurrent.SigInt;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;

public class AeronStat {
    private final CountersReader counters;

    public AeronStat() {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"cnc");
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        if (4 != cncVersion) {
            throw new IllegalStateException("CNC version not supported: file version=" + cncVersion);
        }
        UnsafeBuffer labelsBuffer = CncFileDescriptor.createCountersMetaDataBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaData);
        UnsafeBuffer valuesBuffer = CncFileDescriptor.createCountersValuesBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaData);
        this.counters = new CountersReader((AtomicBuffer)labelsBuffer, (AtomicBuffer)valuesBuffer);
    }

    public void print(PrintStream out) {
        out.format("%1$tH:%1$tM:%1$tS - Aeron Stat\n", new Date());
        out.println("=========================");
        this.counters.forEach((counterId, label) -> {
            long value = this.counters.getCounterValue(counterId.intValue());
            out.format("%3d: %,20d - %s\n", counterId, value, label);
        });
    }

    public void encode(ByteBuffer buffer) {
        buffer.putLong(System.currentTimeMillis());
        this.counters.forEach((counterId, label) -> {
            buffer.putInt((int)counterId);
            buffer.putInt(label.length());
            buffer.put(label.getBytes());
            buffer.putLong(this.counters.getCounterValue(counterId.intValue()));
        });
    }

    public static void main(String[] args) throws Exception {
        AeronStat aeronStat = new AeronStat();
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            System.out.print("\u001b[H\u001b[2J");
            aeronStat.print(System.out);
            System.out.println("--");
            Thread.sleep(1000L);
        }
    }
}

