/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import uk.co.real_logic.aeron.Aeron;
import uk.co.real_logic.aeron.Publication;
import uk.co.real_logic.aeron.driver.MediaDriver;
import uk.co.real_logic.aeron.samples.SampleConfiguration;
import uk.co.real_logic.agrona.CloseHelper;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;

public class BasicPublisher {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final long NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final long LINGER_TIMEOUT_MS = SampleConfiguration.LINGER_TIMEOUT_MS;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;
    private static final UnsafeBuffer BUFFER = new UnsafeBuffer(ByteBuffer.allocateDirect(256));

    public static void main(String[] args) throws Exception {
        System.out.println("Publishing to " + CHANNEL + " on stream Id " + STREAM_ID);
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        Aeron.Context ctx = new Aeron.Context();
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Publication publication = aeron.addPublication(CHANNEL, STREAM_ID);){
            int i = 0;
            while ((long)i < NUMBER_OF_MESSAGES) {
                String message = "Hello World! " + i;
                byte[] messageBytes = message.getBytes();
                BUFFER.putBytes(0, messageBytes);
                System.out.print("offering " + i + "/" + NUMBER_OF_MESSAGES);
                long result = publication.offer((DirectBuffer)BUFFER, 0, messageBytes.length);
                if (result < 0L) {
                    if (result == -2L) {
                        System.out.println("Offer failed due to back pressure");
                    } else if (result == -1L) {
                        System.out.println("Offer failed because publisher is not yet connected to subscriber");
                    } else if (result == -3L) {
                        System.out.println("Offer failed because of an administration action in the system");
                    } else {
                        if (result == -4L) {
                            System.out.println("Offer failed publication is closed");
                            break;
                        }
                        System.out.println("Offer failed due to unknown reason");
                    }
                } else {
                    System.out.println("yay!");
                }
                if (!publication.isConnected()) {
                    System.out.println("No active subscribers detected");
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                ++i;
            }
            System.out.println("Done sending.");
            if (0L < LINGER_TIMEOUT_MS) {
                System.out.println("Lingering for " + LINGER_TIMEOUT_MS + " milliseconds...");
                Thread.sleep(LINGER_TIMEOUT_MS);
            }
        }
        CloseHelper.quietClose((AutoCloseable)driver);
    }
}

