/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.co.real_logic.aeron.CncFileDescriptor;
import uk.co.real_logic.aeron.CommonContext;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.IoUtil;
import uk.co.real_logic.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.agrona.concurrent.errors.ErrorLogReader;

public class ErrorStat {
    public static void main(String[] args) throws Exception {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"cnc");
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        if (4 != cncVersion) {
            throw new IllegalStateException("CNC version not supported: file version=" + cncVersion);
        }
        UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaDataBuffer);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        int distinctErrorCount = ErrorLogReader.read((AtomicBuffer)buffer, (observationCount, firstObservationTimestamp, lastObservationTimestamp, encodedException) -> System.out.format("***\n%d observations from %s to %s for:\n %s\n", observationCount, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), encodedException));
        System.out.format("\n%d distinct errors observed.\n", distinctErrorCount);
    }
}

