/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.io.PrintStream;
import java.util.Date;
import uk.co.real_logic.aeron.LogBuffers;
import uk.co.real_logic.aeron.logbuffer.LogBufferDescriptor;
import uk.co.real_logic.aeron.protocol.DataHeaderFlyweight;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;

public class LogInspector {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String DATA_FORMAT = System.getProperty("aeron.log.inspector.data.format", "hex").toLowerCase();
    private static final boolean SKIP_DEFAULT_HEADER = Boolean.getBoolean("aeron.log.inspector.skipDefaultHeader");

    public static void main(String[] args) throws Exception {
        PrintStream out = System.out;
        if (args.length < 1) {
            out.println("Usage: LogInspector <logFileName> [message dump limit]");
            return;
        }
        String logFileName = args[0];
        int messageDumpLimit = args.length >= 2 ? Integer.parseInt(args[1]) : Integer.MAX_VALUE;
        try (LogBuffers logBuffers = new LogBuffers(logFileName);){
            int i;
            out.println("======================================================================");
            out.format("%s Inspection dump for %s\n", new Date(), logFileName);
            out.println("======================================================================");
            UnsafeBuffer[] atomicBuffers = logBuffers.atomicBuffers();
            DataHeaderFlyweight dataHeaderFlyweight = new DataHeaderFlyweight();
            int termLength = logBuffers.termLength();
            UnsafeBuffer logMetaDataBuffer = atomicBuffers[6];
            out.format("Initial term id: %d\n", LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaDataBuffer));
            out.format("   Active index: %d\n", LogBufferDescriptor.activePartitionIndex((UnsafeBuffer)logMetaDataBuffer));
            out.format("    Term length: %d\n", termLength);
            out.format("     MTU length: %d\n\n", LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaDataBuffer));
            if (!SKIP_DEFAULT_HEADER) {
                dataHeaderFlyweight.wrap((DirectBuffer)LogBufferDescriptor.defaultFrameHeader((UnsafeBuffer)logMetaDataBuffer));
                out.format("default %s\n", dataHeaderFlyweight);
            }
            out.println();
            for (i = 0; i < 3; ++i) {
                UnsafeBuffer metaDataBuffer = atomicBuffers[i + 3];
                out.format("Index %d Term Meta Data status=%s tail=%d\n", i, LogInspector.termStatus(metaDataBuffer), metaDataBuffer.getLong(LogBufferDescriptor.TERM_TAIL_COUNTER_OFFSET) & 0xFFFFFFFFL);
            }
            block12: for (i = 0; i < 3; ++i) {
                int frameLength;
                out.println("\n======================================================================");
                out.format("Index %d Term Data\n\n", i);
                UnsafeBuffer termBuffer = logBuffers.atomicBuffers()[i];
                dataHeaderFlyweight.wrap((DirectBuffer)termBuffer);
                int offset = 0;
                do {
                    int limit;
                    dataHeaderFlyweight.wrap((DirectBuffer)termBuffer, offset, termLength - offset);
                    out.println(dataHeaderFlyweight.toString());
                    frameLength = dataHeaderFlyweight.frameLength();
                    if (frameLength < 24) {
                        try {
                            limit = Math.min(termLength - (offset + 24), messageDumpLimit);
                            out.println(LogInspector.formatBytes((DirectBuffer)termBuffer, offset + 24, limit));
                        }
                        catch (Exception ex) {
                            System.out.printf("frameLength=%d offset=%d\n", frameLength, offset);
                            ex.printStackTrace();
                        }
                        continue block12;
                    }
                    limit = Math.min(frameLength - 24, messageDumpLimit);
                    out.println(LogInspector.formatBytes((DirectBuffer)termBuffer, offset + 24, limit));
                } while ((offset += BitUtil.align((int)frameLength, (int)8)) < termLength);
            }
        }
    }

    public static char[] formatBytes(DirectBuffer buffer, int offset, int length) {
        switch (DATA_FORMAT) {
            case "ascii": {
                return LogInspector.bytesToAscii(buffer, offset, length);
            }
        }
        return LogInspector.bytesToHex(buffer, offset, length);
    }

    private static char[] bytesToAscii(DirectBuffer buffer, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            byte b = buffer.getByte(offset + i);
            if (b < 0) {
                b = 0;
            }
            chars[i] = (char)b;
        }
        return chars;
    }

    public static char[] bytesToHex(DirectBuffer buffer, int offset, int length) {
        char[] chars = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int b = buffer.getByte(offset + i) & 0xFF;
            chars[i * 2] = HEX_ARRAY[b >>> 4];
            chars[i * 2 + 1] = HEX_ARRAY[b & 0xF];
        }
        return chars;
    }

    private static String termStatus(UnsafeBuffer metaDataBuffer) {
        int status = metaDataBuffer.getInt(LogBufferDescriptor.TERM_STATUS_OFFSET);
        switch (status) {
            case 0: {
                return "CLEAN";
            }
            case 1: {
                return "NEEDS_CLEANING";
            }
        }
        return status + " <UNKNOWN>";
    }
}

