/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.nio.ByteBuffer;
import uk.co.real_logic.aeron.Aeron;
import uk.co.real_logic.aeron.Publication;
import uk.co.real_logic.aeron.samples.SampleConfiguration;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;

public class MultiplePublishersWithFragmentation {
    private static final int STREAM_ID_1 = SampleConfiguration.STREAM_ID;
    private static final int STREAM_ID_2 = SampleConfiguration.STREAM_ID + 1;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final UnsafeBuffer BUFFER_1 = new UnsafeBuffer(ByteBuffer.allocateDirect(10000));
    private static final UnsafeBuffer BUFFER_2 = new UnsafeBuffer(ByteBuffer.allocateDirect(9000));

    public static void main(String[] args) throws Exception {
        System.out.println("Publishing to " + CHANNEL + " on stream Id " + STREAM_ID_1 + " and stream Id " + STREAM_ID_2);
        try (Aeron aeron = Aeron.connect();
             Publication publication1 = aeron.addPublication(CHANNEL, STREAM_ID_1);
             Publication publication2 = aeron.addPublication(CHANNEL, STREAM_ID_2);){
            int j = 1;
            int k = 1;
            String message1 = "Hello World! " + j;
            BUFFER_1.putBytes(0, message1.getBytes());
            String message2 = "Hello World! " + k;
            BUFFER_2.putBytes(0, message2.getBytes());
            while (j <= 5000 || k <= 5000) {
                boolean offerStatus1 = false;
                boolean offerStatus2 = false;
                while (!offerStatus1 && !offerStatus2) {
                    if (j <= 5000) {
                        long result1 = publication1.offer((DirectBuffer)BUFFER_1, 0, BUFFER_1.capacity());
                        if (result1 < 0L) {
                            if (result1 == -2L) {
                                System.out.println(" Offer failed due to back pressure for stream Id " + STREAM_ID_1);
                            } else if (result1 == -1L) {
                                System.out.println(" Offer failed because publisher is not yet connected to subscriber for stream Id " + STREAM_ID_1);
                            } else {
                                System.out.println(" Offer failed due to unknown reason");
                            }
                            offerStatus1 = false;
                        } else {
                            ++j;
                            offerStatus1 = true;
                            System.out.println("Successfully sent data on stream " + STREAM_ID_1 + " and data length " + BUFFER_1.capacity() + " at offset " + result1);
                        }
                    }
                    if (k > 5000) continue;
                    long result2 = publication2.offer((DirectBuffer)BUFFER_2, 0, BUFFER_2.capacity());
                    if (result2 < 0L) {
                        if (result2 == -2L) {
                            System.out.println(" Offer failed because publisher is not yet connected to subscriber for stream Id " + STREAM_ID_2);
                        } else if (result2 == -1L) {
                            System.out.println("Offer failed - publisher is not yet connected to subscriber" + STREAM_ID_2);
                        } else {
                            System.out.println("Offer failed due to unknown reason");
                        }
                        offerStatus2 = false;
                        continue;
                    }
                    ++k;
                    offerStatus2 = true;
                    System.out.println("Successfully sent data on stream " + STREAM_ID_2 + " and data length " + BUFFER_2.capacity() + " at offset " + result2);
                }
            }
            System.out.println("Done sending total messages for stream Id " + STREAM_ID_1 + " = " + (j - 1) + " and stream Id " + STREAM_ID_2 + " = " + (k - 1));
        }
    }
}

