/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.real_logic.aeron.Aeron;
import uk.co.real_logic.aeron.FragmentAssembler;
import uk.co.real_logic.aeron.Publication;
import uk.co.real_logic.aeron.Subscription;
import uk.co.real_logic.aeron.driver.MediaDriver;
import uk.co.real_logic.aeron.logbuffer.FragmentHandler;
import uk.co.real_logic.aeron.samples.SampleConfiguration;
import uk.co.real_logic.agrona.CloseHelper;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.agrona.concurrent.NoOpIdleStrategy;
import uk.co.real_logic.agrona.concurrent.SigInt;

public class Pong {
    private static final int PING_STREAM_ID = SampleConfiguration.PING_STREAM_ID;
    private static final int PONG_STREAM_ID = SampleConfiguration.PONG_STREAM_ID;
    private static final String PING_CHANNEL = SampleConfiguration.PING_CHANNEL;
    private static final String PONG_CHANNEL = SampleConfiguration.PONG_CHANNEL;
    private static final int FRAME_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;
    private static final IdleStrategy PING_HANDLER_IDLE_STRATEGY = new NoOpIdleStrategy();

    public static void main(String[] args) throws Exception {
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        Aeron.Context ctx = new Aeron.Context();
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        NoOpIdleStrategy idleStrategy = new NoOpIdleStrategy();
        System.out.println("Subscribing Ping at " + PING_CHANNEL + " on stream Id " + PING_STREAM_ID);
        System.out.println("Publishing Pong at " + PONG_CHANNEL + " on stream Id " + PONG_STREAM_ID);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Publication pongPublication = aeron.addPublication(PONG_CHANNEL, PONG_STREAM_ID);
             Subscription pingSubscription = aeron.addSubscription(PING_CHANNEL, PING_STREAM_ID);){
            FragmentAssembler dataHandler = new FragmentAssembler((buffer, offset, length, header) -> Pong.pingHandler(pongPublication, buffer, offset, length));
            while (running.get()) {
                idleStrategy.idle(pingSubscription.poll((FragmentHandler)dataHandler, FRAME_COUNT_LIMIT));
            }
            System.out.println("Shutting down...");
        }
        CloseHelper.quietClose((AutoCloseable)driver);
    }

    public static void pingHandler(Publication pongPublication, DirectBuffer buffer, int offset, int length) {
        if (pongPublication.offer(buffer, offset, length) > 0L) {
            return;
        }
        PING_HANDLER_IDLE_STRATEGY.reset();
        while (pongPublication.offer(buffer, offset, length) < 0L) {
            PING_HANDLER_IDLE_STRATEGY.idle();
        }
    }
}

