/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.real_logic.aeron.Aeron;
import uk.co.real_logic.aeron.FragmentAssembler;
import uk.co.real_logic.aeron.Subscription;
import uk.co.real_logic.aeron.driver.MediaDriver;
import uk.co.real_logic.aeron.driver.RateReporter;
import uk.co.real_logic.aeron.logbuffer.FragmentHandler;
import uk.co.real_logic.aeron.samples.SampleConfiguration;
import uk.co.real_logic.aeron.samples.SamplesUtil;
import uk.co.real_logic.agrona.CloseHelper;
import uk.co.real_logic.agrona.concurrent.SigInt;

public class RateSubscriber {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;

    public static void main(String[] args) throws Exception {
        System.out.println("Subscribing to " + CHANNEL + " on stream Id " + STREAM_ID);
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Aeron.Context ctx = new Aeron.Context().availableImageHandler(SamplesUtil::printAvailableImage).unavailableImageHandler(SamplesUtil::printUnavailableImage);
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        RateReporter reporter = new RateReporter(TimeUnit.SECONDS.toNanos(1L), SamplesUtil::printRate);
        FragmentAssembler rateReporterHandler = new FragmentAssembler(SamplesUtil.rateReporterHandler(reporter));
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> {
            reporter.halt();
            running.set(false);
        });
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Subscription subscription = aeron.addSubscription(CHANNEL, STREAM_ID);){
            Future<?> future = executor.submit(() -> RateSubscriber.lambda$main$18((FragmentHandler)rateReporterHandler, running, subscription));
            reporter.run();
            System.out.println("Shutting down...");
            future.get();
        }
        executor.shutdown();
        if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.out.println("Warning: not all tasks completed promptly");
        }
        CloseHelper.quietClose((AutoCloseable)driver);
    }

    private static /* synthetic */ void lambda$main$18(FragmentHandler fragmentHandler, AtomicBoolean atomicBoolean, Subscription subscription) {
        SamplesUtil.subscriberLoop(fragmentHandler, FRAGMENT_COUNT_LIMIT, atomicBoolean).accept(subscription);
    }
}

