/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import uk.co.real_logic.aeron.Image;
import uk.co.real_logic.aeron.Subscription;
import uk.co.real_logic.aeron.driver.RateReporter;
import uk.co.real_logic.aeron.logbuffer.FragmentHandler;
import uk.co.real_logic.aeron.protocol.HeaderFlyweight;
import uk.co.real_logic.agrona.LangUtil;
import uk.co.real_logic.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.agrona.concurrent.NoOpIdleStrategy;

public class SamplesUtil {
    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running) {
        NoOpIdleStrategy idleStrategy = new NoOpIdleStrategy();
        return SamplesUtil.subscriberLoop(fragmentHandler, limit, running, (IdleStrategy)idleStrategy);
    }

    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running, IdleStrategy idleStrategy) {
        return subscription -> {
            try {
                while (running.get()) {
                    idleStrategy.idle(subscription.poll(fragmentHandler, limit));
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Exception)ex);
            }
        };
    }

    public static FragmentHandler printStringMessage(int streamId) {
        return (buffer, offset, length, header) -> {
            byte[] data = new byte[length];
            buffer.getBytes(offset, data);
            System.out.println(String.format("Message to stream %d from session %d (%d@%d) <<%s>>", streamId, header.sessionId(), length, offset, new String(data)));
        };
    }

    public static FragmentHandler rateReporterHandler(RateReporter reporter) {
        return (buffer, offset, length, header) -> reporter.onMessage(1L, (long)length);
    }

    public static void printError(String channel, int streamId, int sessionId, String message, HeaderFlyweight cause) {
        System.out.println(message);
    }

    public static void printRate(double messagesPerSec, double bytesPerSec, long totalMessages, long totalBytes) {
        System.out.println(String.format("%.02g msgs/sec, %.02g bytes/sec, totals %d messages %d MB", messagesPerSec, bytesPerSec, totalMessages, totalBytes / 0x100000L));
    }

    public static void printAvailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Available image on %s streamId=%d sessionId=%d from %s", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity()));
    }

    public static void printUnavailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Unavailable image on %s streamId=%d sessionId=%d", subscription.channel(), subscription.streamId(), image.sessionId()));
    }
}

