/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.nio.ByteBuffer;
import uk.co.real_logic.aeron.Aeron;
import uk.co.real_logic.aeron.Publication;
import uk.co.real_logic.agrona.DirectBuffer;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;

public class SimplePublisher {
    public static void main(String[] args) throws Exception {
        UnsafeBuffer buffer = new UnsafeBuffer(ByteBuffer.allocateDirect(512));
        String channel = "udp://localhost:40123";
        int streamId = 10;
        System.out.println("Publishing to udp://localhost:40123 on stream Id 10");
        Aeron.Context ctx = new Aeron.Context();
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Publication publication = aeron.addPublication("udp://localhost:40123", 10);){
            String message = "Hello World! ";
            byte[] messageBytes = "Hello World! ".getBytes();
            buffer.putBytes(0, messageBytes);
            long result = publication.offer((DirectBuffer)buffer, 0, messageBytes.length);
            if (result < 0L) {
                if (result == -2L) {
                    System.out.println(" Offer failed due to back pressure");
                } else if (result == -1L) {
                    System.out.println(" Offer failed because publisher is not yet connected to subscriber");
                } else if (result == -3L) {
                    System.out.println("Offer failed because of an administration action in the system");
                } else if (result == -4L) {
                    System.out.println("Offer failed publication is closed");
                } else {
                    System.out.println(" Offer failed due to unknown reason");
                }
            } else {
                System.out.println(" yay !!");
            }
            System.out.println("Done sending.");
        }
    }
}

