/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.real_logic.aeron.Aeron;
import uk.co.real_logic.aeron.Subscription;
import uk.co.real_logic.aeron.logbuffer.FragmentHandler;
import uk.co.real_logic.agrona.concurrent.BackoffIdleStrategy;
import uk.co.real_logic.agrona.concurrent.SigInt;

public class SimpleSubscriber {
    public static void main(String[] args) throws Exception {
        int fragmentLimitCount = 10;
        String channel = "udp://localhost:40123";
        int streamId = 10;
        System.out.println("Subscribing to udp://localhost:40123 on stream Id 10");
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        FragmentHandler fragmentHandler = (buffer, offset, length, header) -> {
            byte[] data = new byte[length];
            buffer.getBytes(offset, data);
            System.out.println(String.format("Received message (%s) to stream %d from session %x term id %x term offset %d (%d@%d)", new String(data), 10, header.sessionId(), header.termId(), header.termOffset(), length, offset));
            running.set(false);
        };
        Aeron.Context ctx = new Aeron.Context();
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Subscription subscription = aeron.addSubscription("udp://localhost:40123", 10);){
            BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
            while (running.get()) {
                int fragmentsRead = subscription.poll(fragmentHandler, 10);
                idleStrategy.idle(fragmentsRead);
            }
            System.out.println("Shutting down...");
        }
    }
}

