/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples.raw;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.Selector;
import uk.co.real_logic.agrona.IoUtil;
import uk.co.real_logic.agrona.nio.NioSelectedKeySet;

public class Common {
    public static final int NUM_MESSAGES = 10000;
    public static final int PONG_PORT = 40123;
    public static final int PING_PORT = 50123;
    static final Field SELECTED_KEYS_FIELD;
    static final Field PUBLIC_SELECTED_KEYS_FIELD;

    public static void init(DatagramChannel channel) throws IOException {
        channel.configureBlocking(false);
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
    }

    public static void init(DatagramChannel channel, InetSocketAddress sendAddress) throws IOException {
        channel.configureBlocking(false);
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        channel.connect(sendAddress);
    }

    public static NioSelectedKeySet keySet(Selector selector) {
        NioSelectedKeySet tmpSet = null;
        if (null != PUBLIC_SELECTED_KEYS_FIELD) {
            try {
                tmpSet = new NioSelectedKeySet();
                SELECTED_KEYS_FIELD.set(selector, tmpSet);
                PUBLIC_SELECTED_KEYS_FIELD.set(selector, tmpSet);
            }
            catch (Exception ignore) {
                tmpSet = null;
            }
        }
        return tmpSet;
    }

    public static FileChannel createTmpFileChannel() throws IOException {
        File file = File.createTempFile("buffer-", ".dat");
        file.deleteOnExit();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileChannel fileChannel = randomAccessFile.getChannel();
        IoUtil.fill((FileChannel)fileChannel, (long)0L, (long)4096L, (byte)0);
        return fileChannel;
    }

    static {
        Field selectKeysField = null;
        Field publicSelectKeysField = null;
        try {
            Class<?> clazz = Class.forName("sun.nio.ch.SelectorImpl", false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(Selector.open().getClass())) {
                selectKeysField = clazz.getDeclaredField("selectedKeys");
                selectKeysField.setAccessible(true);
                publicSelectKeysField = clazz.getDeclaredField("publicSelectedKeys");
                publicSelectKeysField.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SELECTED_KEYS_FIELD = selectKeysField;
        PUBLIC_SELECTED_KEYS_FIELD = publicSelectKeysField;
    }
}

