/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples.raw;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToIntFunction;
import uk.co.real_logic.aeron.samples.raw.Common;
import uk.co.real_logic.agrona.concurrent.SigInt;
import uk.co.real_logic.agrona.nio.NioSelectedKeySet;

public class HackSelectReceiveSendUdpPong {
    public static void main(String[] args) throws IOException {
        new HackSelectReceiveSendUdpPong().run();
    }

    private void run() throws IOException {
        InetSocketAddress sendAddress = new InetSocketAddress("localhost", 40123);
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        DatagramChannel receiveChannel = DatagramChannel.open();
        Common.init(receiveChannel);
        receiveChannel.bind(new InetSocketAddress("localhost", 50123));
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        NioSelectedKeySet keySet = Common.keySet(selector);
        ToIntFunction<SelectionKey> handler = key -> {
            try {
                buffer.clear();
                receiveChannel.receive(buffer);
                long receivedSequenceNumber = buffer.getLong(0);
                long receivedTimestamp = buffer.getLong(8);
                buffer.clear();
                buffer.putLong(receivedSequenceNumber);
                buffer.putLong(receivedTimestamp);
                buffer.flip();
                sendChannel.send(buffer, sendAddress);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 1;
        };
        receiveChannel.register(selector, 1, null);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (true) {
            if (selector.selectNow() == 0) {
                if (running.get()) continue;
                return;
            }
            keySet.forEach(handler);
        }
    }
}

