/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.aeron.samples.raw;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.ToIntFunction;
import org.HdrHistogram.Histogram;
import uk.co.real_logic.aeron.samples.raw.Common;
import uk.co.real_logic.agrona.concurrent.SigInt;
import uk.co.real_logic.agrona.nio.NioSelectedKeySet;

public class SendHackSelectReceiveUdpPing
implements ToIntFunction<SelectionKey> {
    private static final InetSocketAddress SEND_ADDRESS = new InetSocketAddress("localhost", 50123);
    private static final Histogram HISTOGRAM = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
    private DatagramChannel receiveChannel;
    private int sequenceNumber;

    public static void main(String[] args) throws IOException {
        new SendHackSelectReceiveUdpPing().run();
    }

    private void run() throws IOException {
        this.receiveChannel = DatagramChannel.open();
        Common.init(this.receiveChannel);
        this.receiveChannel.bind(new InetSocketAddress("localhost", 40123));
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        this.receiveChannel.register(selector, 1, this);
        NioSelectedKeySet keySet = Common.keySet(selector);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            this.measureRoundTrip(HISTOGRAM, SEND_ADDRESS, this.buffer, sendChannel, selector, keySet, running);
            HISTOGRAM.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    @Override
    public int applyAsInt(SelectionKey key) {
        try {
            this.buffer.clear();
            this.receiveChannel.receive(this.buffer);
            long receivedSequenceNumber = this.buffer.getLong(0);
            long timestamp = this.buffer.getLong(8);
            if (receivedSequenceNumber != (long)this.sequenceNumber) {
                throw new IllegalStateException("Data Loss:" + this.sequenceNumber + " to " + receivedSequenceNumber);
            }
            long duration = System.nanoTime() - timestamp;
            HISTOGRAM.recordValue(duration);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return 1;
    }

    private void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, DatagramChannel sendChannel, Selector selector, NioSelectedKeySet keySet, AtomicBoolean running) throws IOException {
        this.sequenceNumber = 0;
        while (this.sequenceNumber < 10000) {
            long timestamp = System.nanoTime();
            buffer.clear();
            buffer.putLong(this.sequenceNumber);
            buffer.putLong(timestamp);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
            while (selector.selectNow() == 0) {
                if (running.get()) continue;
                return;
            }
            keySet.forEach((ToIntFunction)this);
            ++this.sequenceNumber;
        }
        histogram.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
    }
}

